/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;

import javax.management.j2ee.statistics.Statistic;

import javax.management.openmbean.CompositeData;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;

/**
	Implementation of Statistic which expects a CompositeData to contain
	them by name.
 */
public class CompositeDataStatistic extends MapStatisticImpl
{
    static final long serialVersionUID = -3563385569398388449L;
    
	/**
		Create a new CompositeDataStatistic using the specified {@link CompositeData}.
		Create from a {@link CompositeData}
	 */
		public
	CompositeDataStatistic( final CompositeData compositeData )
	{
		this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
	}
	
	/**
		Create a new instance using the specified {@link Map}
		whose keys are the Statistic names.
	 */
		public
	CompositeDataStatistic( final Map<String,?> map )
	{
		super( map );
	}
	
	/**
		Create a new instance using the specified Statistic as the source
		for the members.
	 */
		public
	CompositeDataStatistic( final Statistic statistic )
	{
		super( statistic );
	}
}





