/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/statistics/Attic/CompositeDataStats.java,v 1.4 2006/03/09 20:30:28 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:28 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Set;
import java.util.Map;


import javax.management.openmbean.CompositeData;

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.Statistic;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;

/**
	Implementation of Stats which expects a CompositeData to contain
	the Statistics keyed by name, with values of CompositeData.
 */
public final class CompositeDataStats implements Stats
{
	final Map<String,?>	mItems;
	
	/**
		Create a new CompositeDataStats using the specified CompositeData
	 */
		public
	CompositeDataStats( final CompositeData compositeData )
	{
		mItems	= OpenMBeanUtil.compositeDataToMap( compositeData );
	}
	
		public Statistic
	getStatistic( String statisticName )
	{
		final CompositeData	statData	= (CompositeData)mItems.get( statisticName );
		if ( statData == null && ! mItems.containsKey( statisticName ) )
		{
			throw new IllegalArgumentException( statisticName );
		}
		
		return( new CompositeDataStatistic( statData ) );
	}
	
		public String[]
	getStatisticNames()
	{
		final Set<String>	nameSet	= mItems.keySet();
		
		return( (String[])nameSet.toArray( new String[ nameSet.size() ] ) );
	}
	
		public Statistic[]
	getStatistics()
	{
		final String[]		names		= getStatisticNames();
		final Statistic[]	statistics	= new Statistic[ names.length ];
		
		for( int i = 0; i < names.length; ++i )
		{
			statistics[ i ]	= getStatistic( names[ i ] );
		}
		
		return( statistics );
	}
   
}





