/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.management.monitor.statistics;

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import com.sun.appserv.management.j2ee.statistics.StringStatistic;
import com.sun.appserv.management.j2ee.statistics.NumberStatistic;

/**
 * Web Service Endpoint's stats interface. It provides faults, response time,
 * throughput and authentication failure/success information.
 *
 * @since AppServer 9.0
 */
public interface WebServiceEndpointAggregateStats extends Stats
{
    /**
     * Returns the total number of fault as a CountStatistic.
     * Generally if an Endpoint results in a fault, this count will
     * increment by one.
     *
     * @return an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalFaults();

    /**
     * Returns the total number of successful runs, as a CountStatistic.
     * Generally if an operation returns with out a fault it is consider a
     * success. normally, this count will increment by one.
     *
     * @return an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalNumSuccess();

    /**
     * Returns the average time in milli seconds spent during the last 
     * successful/unsuccessful attempt to execute the operation, as a
     * CountStatistic. The time spent is generally an indication of 
     * the system load/processing time.
     *
     * @return an instance of {@link CountStatistic}
     */
    public CountStatistic getAverageResponseTime();

    /**
     * Returns the time in milli seconds spent during the last 
     * successful/unsuccessful attempt to execute the operation, as a
     * CountStatistic.  
     *
     * @return an instance of {@link CountStatistic}
     */
    public CountStatistic getResponseTime();

    /**
     * Returns the minimum time spent in milli seconds for any successful/
     * unsuccessful attempt to execute the operation, as a CountStatistic.
     *
     * @return an instance of {@link CountStatistic}
     */
    public CountStatistic getMinResponseTime();

    /**
     * Returns the maximum time spent in milli seconds for any successful/
     * unsuccessful attempt to execute the operation, as a CountStatistic.
     *
     * @return an instance of {@link CountStatistic}
     */
    public CountStatistic getMaxResponseTime();

    /**
     * Returns the number successful messages/minute since the server is
     * started as a NumberStatistic.
     *
     * @return an instance of {@link NumberStatistic}
     */
    public NumberStatistic getThroughput();

    /**
     * Returns the total number of authentication failures as a
     * CountStatistic.
     *
     * @return an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalAuthFailures();

    /**
     * Returns the total number of authentication successes
     * CountStatistic.
     *
     * @return an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalAuthSuccesses();
}
