/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/jmx/stringifier/Attic/MBeanNotificationInfoStringifier.java,v 1.3 2005/12/25 03:51:36 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:36 $
 */
 

package com.sun.appserv.management.util.jmx.stringifier;

import javax.management.MBeanNotificationInfo;


import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;

public class MBeanNotificationInfoStringifier
	extends MBeanFeatureInfoStringifier implements Stringifier
{
	public final static MBeanNotificationInfoStringifier	DEFAULT	= new MBeanNotificationInfoStringifier();

		public
	MBeanNotificationInfoStringifier()
	{
		super( );
	}
	
		public
	MBeanNotificationInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		super( options );
	}
	
		public String
	stringify( Object o )
	{
		final MBeanNotificationInfo	notif	= (MBeanNotificationInfo)o;
		
		String	result	= notif.getName() + ":";
		
		final String []	notifTypes	= notif.getNotifTypes();
		result	= result + ArrayStringifier.stringify( notifTypes, mOptions.mArrayDelimiter );
		
		if ( mOptions.mIncludeDescription )
		{
			result	= result + ",\"" + notif.getDescription() + "\"";
		}
				
		
		return( result );
	}
}