/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.jmx.stringifier;

import java.util.Date;
import javax.management.Notification;
import javax.management.MBeanServerNotification;

import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.appserv.management.util.misc.StringUtil;

public class NotificationStringifier implements Stringifier
{
	public static final NotificationStringifier	DEFAULT	= new NotificationStringifier();
	
	protected Options	mOptions;
	
	public final static class Options
	{
		// don't make 'final' fields; allow changes after instantiation
		public boolean	mIncludeObjectName;
		public boolean	mIncludeTimeStamp;
		public boolean	mIncludeType;
		public boolean	mIncludeSequenceNumber;
		public boolean	mIncludeUserData;
		public String	mDelim;
		
			public
		Options()
		{
			mIncludeObjectName		= true;
			mIncludeTimeStamp		= true;
			mIncludeType			= true;
			mIncludeSequenceNumber	= true;
			mIncludeUserData		= false;
			mDelim	= ", ";
		}
		
	}
	
	
		public
	NotificationStringifier( )
	{
		mOptions	= new Options();
	}
	
		public
	NotificationStringifier( Options options )
	{
		mOptions	= options;
	}
		
		protected void
	append( StringBuffer b, Object o)
	{
		if ( b.length() != 0 )
		{
			b.append( mOptions.mDelim );
		}
		
		b.append( SmartStringifier.toString( o ) );
	}
	
		public String
	stringify( Object o )
	{
		final Notification	notif	= (Notification)o;
		
		return( _stringify( notif ).toString() );
	}
	
		public static String
	toString( Object o )
	{
		return( DEFAULT.stringify( o ) );
	}
	
		protected StringBuffer
	_stringify( Notification notif )
	{
		final StringBuffer	b	= new StringBuffer();
		
		if ( mOptions.mIncludeSequenceNumber )
		{
			append( b, "#" + notif.getSequenceNumber() );
		}

		if ( mOptions.mIncludeTimeStamp )
		{
			append( b, new Date( notif.getTimeStamp() ) );
		}

		if ( mOptions.mIncludeObjectName )
		{
			append( b, StringUtil.quote( notif.getSource() ) );
		}

		if ( mOptions.mIncludeType )
		{
			append( b, notif.getType() );
		}

		if ( mOptions.mIncludeUserData )
		{
			append( b, StringUtil.quote( notif.getUserData() ) );
		}
		
		if ( notif instanceof MBeanServerNotification )
		{
			// this should really be done in a MBeanServerNotificationStringifier!
			final MBeanServerNotification	n	= (MBeanServerNotification)notif;
			
			append( b, StringUtil.quote( n.getMBeanName() ) );
		}
		
		return( b );
	}
}



















