/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.stringifier;

/**
	Stringifies an object based on specified interfaces.
 */
public class InterfacesStringifier implements Stringifier
{
	private final StringifierRegistry	mRegistry;
	private final Class<?>[]				mInterfaces;
	
		public 
	InterfacesStringifier( Class[] interfaces  )
	{
		this( StringifierRegistryImpl.DEFAULT, interfaces );
	}
	
		public 
	InterfacesStringifier( StringifierRegistry registry, Class[] interfaces)
	{
		mRegistry	= registry;
		mInterfaces	= interfaces;
	}
	
		private <T> String
	stringifyAs( Object o, Class<T> theClass )
	{
		String	result	= null;
		if ( theClass.isAssignableFrom( o.getClass() ) )
		{
			final Stringifier	stringifier	= mRegistry.lookup( theClass );
			if ( stringifier != null )
			{
				result	= stringifier.stringify( o );
			}
		}
		return( result );
	}
	
		public String
	stringify( Object o )
	{
		String	result	= "";
		
		for( int i = 0; i < mInterfaces.length; ++i )
		{
			final Class<?> intf	= mInterfaces[ i ];
			
			final String s	= stringifyAs( o, intf );
			if ( s != null )
			{
				result	= result + intf.getName() + ": " + s + "\n";
			}
		}
		
		if ( result == null || result.length() == 0)
		{
			result	= o.toString();
		}
	
		return( result );
	}
}








