/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * JndiMBean.java
 *
 * Created on March 8, 2004, 1:42 PM
 */

package com.sun.enterprise.admin.monitor.jndi;

import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.naming.NameClassPair;
import javax.naming.NamingException;

/**
 * The JndiMBean DynamicMBean interface.
 * @author Rob Ruyak 
 */
public interface JndiMBean extends DynamicMBean {
    
    /**
     * Gets the jndi naming entries given a particular context
     * or subcontext.
     *
     * @param context The context name under which the entries live.
     * @return An array of serializable NameClassPair objects.
     * @throws MBeanException when an error occurs in retrieving the entries.
     */
    public java.util.ArrayList getNames(String context) throws NamingException;
    
}
