/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: EJBMethodStats.java,v 1.2 2005/12/25 03:52:13 tcfujii Exp $
 * $Date: 2005/12/25 03:52:13 $
 * $Revision: 1.2 $
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

/** A Stats interface to represent the statistical data exposed by an EJB Business Method.
 * These are based on the statistics exposed in S1AS7.0. 
 * All the EJB Methods should expose statistical data by implementing this interface.
 * @author Muralidhar Vempaty
 * @author Kedar Mhaswade
 * @since S1AS8.0
 * @version 1.0
 */

public interface EJBMethodStats extends Stats {
    
	/** Returns the statistics of the method invocation as an instance of TimeStatistic.
	 * Note that it returns the number of times the operation called, the total time
	 * that was spent during the invocation and so on. All the calculations of the
	 * statistic are being done over time.
	 * @return in instance of {@link TimeStatistic}
	 */
	public TimeStatistic getMethodStatistic();
	
    /** Returns the total number of errors as a CountStatistic. It is upto the method
	 * implementor to characterize what an error is. Generally if an operation results in 
	 * an exception, this count will increment by one.
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalNumErrors();
    
    /** Returns the total number of successful runs, as a CountStatistic. It is upto the method
	 * implementor to characterize what a successful run is. Generally if an operation returns
	 * normally, this count will increment by one.
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalNumSuccess();
    
    /** Returns the time spent during the last successful/unsuccessful attempt to execute the operation, as a CountStatistic.
	 * The time spent is generally an indication of the system load/processing time.
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getExecutionTime();    
}
