/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: EJBPoolStats.java,v 1.2 2005/12/25 03:52:13 tcfujii Exp $
 * $Date: 2005/12/25 03:52:13 $
 * $Revision: 1.2 $
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

/** A Stats interface to represent the statistical data exposed by an EJB Bean Pool.
 * These are based on the statistics exposed in S1AS7.0. 
 * All the EJB Pool implementations should expose statistical data by implementing this interface.
 * @author Muralidhar Vempaty
 * @author Kedar Mhaswade
 * @since S1AS8.0
 * @version 1.0
 */

public interface EJBPoolStats extends Stats {

	/** Returns the statistical information about the number of EJBs in the associated pool, as an instance of BoundedRangeStatistic.
	 * This returned value gives an idea about how the pool is changing.
	 * @return		an instance of {@link BoundedRangeStatistic}
     */
    public BoundedRangeStatistic getNumBeansInPool();
    
    /** Returns the number of threads waiting for free Beans, as an instance of CountStatistic.
	 * This indicates the congestion of requests.
	 * @return		an instance of {@link BoundedRangeStatistic}
     */
    public BoundedRangeStatistic getNumThreadsWaiting();
    
    /** Returns the number of Beans created in associated pool so far over time, since the gathering of data started, as a CountStatistic.
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalBeansCreated();
    
    /** Returns the number of Beans destroyed from associated pool so far over time, since the gathering of data started, as a CountStatistic.
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalBeansDestroyed();
    
    /** Returns the maximum number of messages to load into a JMS session, at a time, as a CountStatistic.
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getJmsMaxMessagesLoad();
}
