/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * JTAStats.java
 *
 * Created on August 14, 2003, 12:53 PM
 */

package com.sun.enterprise.admin.monitor.stats;

import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import java.util.List;
import java.util.Map;

/** Defines additional Sun ONE Application Server specific statistic to transaction service.
 * @author  <a href="mailto:Kedar.Mhaswade@sun.com">Kedar Mhaswade</a>
 * @since S1AS8.0
 * @version $Revision: 1.3 $
 */
public interface JTAStats extends javax.management.j2ee.statistics.JTAStats {

	/** Returns the IDs of the transactions that are currently active, as a StrignStatistic. 
	 * An active transaction is same as an in-flight transaction. Every such transaction can be rolled back after
	 * freezing the transaction service.
	 * @see javax.management.j2ee.statistics.JTAStats#getActiveCount
	 * @return		a comma separated String of IDs
	 */
	public StringStatistic getActiveIds();
	
	/** Returns the current state of the transaction service as a StringStatistic.
	 *
	 * @return		String representing the current state of the transaction service.
	 */
	public StringStatistic getState();
	
	/** Freezes the transaction subsystem. This operation is advised before
	 * an attempt is made to rollback any transactions to avoid the possibility of 
         * transaction completion before the rollback request is issued. The transaction subsystem
	 * is expected be active before it can be frozen. Calling this methd on 
	 * an already frozen transaction subsystem has no effect.
	 */
	public void freeze();
	
	/** Unfreezes the transaction subsystem. It is required to unfreeze the 
	 * transaction subsystem after it is frozen earlier.
	 * Calling this method when system is not active, has no effect.
	 */
	public void unfreeze();
	
	/** 
	 * Rolls back a given transaction. It is advisable to call this method  
         * when the transaction subsystem is in a frozen state so that transactions
         * won't be completed before this request. It is left to implementation how
	 * the transactions are rolled back.
	 * @param	String representing the unique id of the transaction that
	 * needs to be rolled-back. Every transaction that can be rolled back 
	 * has to be an in flight transaction.
         * @return String contains the status of the rollback operation for the given txnId.
         * status contains "Rollback successful", 
         * "Rollback unsuccessful. Current Thread is not associated with the transaction",
         * "Rollback unsuccessful. Thread is not allowed to rollback the transaction",
         * "Rollback unsuccessful. Unexpected error condition encountered by Transaction Manager".
	 */	
	public String rollback(String txnId);
	
	
	/** 
	 * Rolls back the given transactions. It is advisable to call this method  
         * when the transaction subsystem is in a frozen state so that transactions
         * won't be completed before this request. It is left to implementation how
	 * the transactions are rolled back.
	 * @param	String array representing the unique ids of the transactions that
	 * need to be frozen. Every transaction that can be rolled back has to be an
	 * in flight transaction.
	 * @return	String[] containing the status for the given transaction ids.
         * status contains "Successful","Invalid transaction Id or Transaction is over",
         * "Rollback unsuccessful. Current Thread is not associated with the transaction",
         * "Rollback unsuccessful. Unexpected error condition encountered by Transaction Manager".
	
	public String[] rollback(String[] txnIds);
	 */

        // To be used for GUI ... 
        public List<Map<String, String>> listActiveTransactions();
}

