/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;

/**
 * A Stats interface, to expose information 
 * about the Operating system on which the JVM is running
 * @since 8.1
 */
public interface JVMOperatingSystemStats extends Stats {
    
    /**
     * Returns the operating system architecture
     * @return StringStatistic 
     */
    public StringStatistic getArch();
    
    /**
     * Returns the number of processors available to the JVM
     * @return CountStatistic
     */
    public CountStatistic getAvailableProcessors();
    
    /**
     * Returns the operating system name
     * @return StringStatistic
     */
    public StringStatistic getName();
    
    /**
     * Returns the operating system version
     * @return StringStatistic
     */
    public StringStatistic getVersion();
}
