/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;

/**
 * A Stats interface, to expose the monitoring information 
 * about the thread system of the JVM.
 * @since 8.1
 */
public interface JVMThreadStats extends Stats {
    
    /**
     * Returns the current number of live daemon and non-daemon 
     * threads
     * @return CountStatistic   current number of live threads
     */
    public CountStatistic getThreadCount();
    
    /**
     * Returns the peak live thread count, since the JVM started or
     * the peak was reset
     * @return CountStatistic   peak live thread count
     */
    public CountStatistic getPeakThreadCount();
    
    /**
     * Returns the total number of threads created and also started
     * since the JVM started
     * @return CountStatistic   total number of threads started
     */
    public CountStatistic getTotalStartedThreadCount();
    
    /**
     * Returns the current number of live daemon threads
     * @return CountStatistic   current number of live daemon threads
     */
    public CountStatistic getDaemonThreadCount();
    
    /**
     * Returns a comma separated list of all live thread ids
     * @return StringStatistic  live thread ids
     */
    public StringStatistic getAllThreadIds();
    
    /**
     * Returns the CPU time for the current thread in nanoseconds, if
     * CPU time measurement is enabled. Else returns -1
     * @return  CountStatistic  CPU time for the current thread
     */
    public CountStatistic getCurrentThreadCPUTime();
    
    /**
     * Returns a comma separated list of thread ids that are
     * monitor deadlocked
     * @return StringStatistic
     */
    public StringStatistic getMonitorDeadlockedThreads();
    
}
