/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * PWCRequestStats.java
 *
 * Created on April 2, 2004, 10:51 AM
 */

package com.sun.enterprise.admin.monitor.stats;

import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;

/** 
 * Interface representing statistical information about the request bucket 
 */
public interface PWCRequestStats extends Stats {
    
    /**
     * Gets the method of the last request serviced.
     *
     * @return Method of the last request serviced
     */    
    public StringStatistic getMethod();
    
    /**
     * Gets the URI of the last request serviced.
     *
     * @return URI of the last request serviced
     */    
    public StringStatistic getUri();
    
    /** 
     * Gets the number of requests serviced.
     *
     * @return Number of requests serviced
     */    
    public CountStatistic getCountRequests();
    
    /** 
     * Gets the number of bytes received.
     *
     * @return Number of bytes received, or 0 if this information is
     * not available
     */    
    public CountStatistic getCountBytesReceived();
    
    /** 
     * Gets the number of bytes transmitted.
     *
     * @return Number of bytes transmitted, or 0 if this information
     * is not available
     */    
    public CountStatistic getCountBytesTransmitted();
    
    /** 
     * Gets the rate (in bytes per second) at which data was transmitted
     * over some server-defined interval.
     * 
     * @return Rate (in bytes per second) at which data was
     * transmitted over some server-defined interval, or 0 if this
     * information is not available
     */    
    public CountStatistic getRateBytesTransmitted();
    
    /** 
     * Gets the maximum rate at which data was transmitted over some
     * server-defined interval.
     *
     * @return Maximum rate at which data was transmitted over some
     * server-defined interval, or 0 if this information is not available.
     */    
    public CountStatistic getMaxByteTransmissionRate();
    
    /** 
     * Gets the number of open connections.
     *
     * @return Number of open connections, or 0 if this information
     * is not available
     */    
    public CountStatistic getCountOpenConnections();
    
    /** 
     * Gets the maximum number of open connections.
     *
     * @return Maximum number of open connections, or 0 if this
     * information is not available
     */    
    public CountStatistic getMaxOpenConnections();
    
    /** 
     * Gets the number of 200-level responses sent.
     *
     * @return Number of 200-level responses sent
     */    
    public CountStatistic getCount2xx();
    
    /**
     * Gets the number of 300-level responses sent.
     *
     * @return Number of 300-level responses sent
     */    
    public CountStatistic getCount3xx();
    
    /**
     * Gets the number of 400-level responses sent.
     *
     * @return Number of 400-level responses sent
     */    
    public CountStatistic getCount4xx();
    
    /**
     * Gets the number of 500-level responses sent.
     *
     * @return Number of 500-level responses sent
     */    
    public CountStatistic getCount5xx();
    
    /**
     * Gets the number of responses sent that were not 200, 300, 400,
     * or 500 level.
     *
     * @return Number of responses sent that were not 200, 300, 400,
     * or 500 level
     */    
    public CountStatistic getCountOther();
    
    /**
     * Gets the number of responses with a 200 response code.
     *
     * @return Number of responses with a 200 response code
     */    
    public CountStatistic getCount200();
    
    /**
     * Gets the number of responses with a 302 response code.
     *
     * @return Number of responses with a 302 response code
     */    
    public CountStatistic getCount302();
    
    /**
     * Gets the number of responses with a 304 response code.
     *
     * @return Number of responses with a 304 response code
     */    
    public CountStatistic getCount304();
    
    /**
     * Gets the number of responses with a 400 response code.
     *
     * @return Number of responses with a 400 response code
     */    
    public CountStatistic getCount400();
    
    /**
     * Gets the number of responses with a 401 response code.
     *
     * @return Number of responses with a 401 response code
     */    
    public CountStatistic getCount401();
    
    /**
     * Gets the number of responses with a 403 response code.
     *
     * @return Number of responses with a 403 response code
     */    
    public CountStatistic getCount403();
    
    /**
     * Gets the number of responses with a 404 response code.
     *
     * @return Number of responses with a 404 response code
     */    
    public CountStatistic getCount404();
    
    /**
     * Gets the number of responses with a 503 response code.
     *
     * @return Number of responses with a 503 response code
     */    
    public CountStatistic getCount503();
    
}
