/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * PWCVirtualServerStats.java
 *
 * Created on April 2, 2004, 10:45 AM
 */

package com.sun.enterprise.admin.monitor.stats;

/**
 *
 * @author  nsegura
 */
import javax.management.j2ee.statistics.Stats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;

/** 
 * Statistical information relevant to a virtual server 
 */
public interface PWCVirtualServerStats extends Stats {
    
    /** 
     * Returns the virtual server ID
     * @return virtual server ID
     */    
    public StringStatistic getId();

    /** 
     * Returns the current virtual server mode:
     * unknown/active
     * @return virtual server mode
     */    
    public StringStatistic getMode();
    
    /** 
     * Returns the hosts related to this virtual server
     * @return hosts
     */    
    public StringStatistic getHosts();
    
    /** 
     * Returns the interfaces related to this virtual server
     * @return interfaces
     */    
    public StringStatistic getInterfaces();
    
}
