/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.xml.sax.EntityResolver;

import com.iplanet.jato.ModelTypeMap;
import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.PreloadXML;
import com.sun.enterprise.tools.admingui.handlers.CommonHandlers;
import com.sun.enterprise.tools.jsfext.util.ClasspathEntityResolver;
import com.sun.enterprise.tools.guiframework.view.BaseServlet;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.ViewXMLEntityResolver;
import com.sun.enterprise.tools.guiframework.util.LogUtil;

import com.sun.web.ui.renderer.template.xml.XMLLayoutDefinitionManager;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Handler;

import com.sun.web.ui.common.CCPrivateConfiguration;

/**
 *
 */
public class AdminGUIServlet extends BaseServlet {
    
    private static final boolean debug = false;

    public AdminGUIServlet() {
	super();
	setDefaultHandlerName("TopFrameset");
        setEnforceStrictSessionTimeout(true);
        setupConfig();

        // initialize Lockhart
        CCPrivateConfiguration.setEntityResolver(new LockhartEntityResolver());
	((XMLLayoutDefinitionManager) XMLLayoutDefinitionManager.getInstance()).
		setEntityResolver(new ClasspathEntityResolver());
    }
    
    /**
     *	This method provides a last resort spot to handle any uncaught
     *	exceptions or errors.  The preferred way to handle exceptions or errors
     *	is to register and "error" event to dispatch the handling to the
     *	designated handler, however, if that fails or you do not do this, this
     *	method will be invoked.  The ErrorEvent that is passed in will contain
     *	information about what went wrong.  The View and ViewDescriptor
     *	contained in the Error event may be null as there was no handler
     *	defined to take care of this exception.
     *
     *	@param	errorEvent	The ErrorEvent object describing the exception
     */
    protected void handleUncaughtException(ErrorEvent errorEvent) {
	if (Util.isLoggableWARNING()) {
	    Util.logWARNING("Exception NOT handled!", errorEvent.getException());
	}
	ViewDescriptor viewDesc = errorEvent.getCauseViewDescriptor();
	if (Util.isLoggableINFO()) {
	    if (viewDesc != null) {
		Util.logINFO("Problem near ViewDescriptor: '"+viewDesc.getName()+"'");
	    }
	}
	String cause = errorEvent.getCauseMessage();
	if (Util.isLoggableINFO()) {
	    if (cause != null) {
		Util.logINFO(cause);
	    }
	}
	if (Util.isLoggableINFO()) {
	    Util.logINFO(errorEvent.getRegularTrace());
	}
	if (viewDesc != null) {
	    // Find the top ViewDescriptor
	    while (viewDesc.getParent() != null) {
		viewDesc = viewDesc.getParent();
	    }
	    // Get the View / view name
	    RequestContext ctx = RequestManager.getRequestContext();
	    String redirName = null;
	    View view = null;
	    try {
		view = viewDesc.getView(ctx);
		while (view.getParent() != null) {
		    view = view.getParent();
		}
		redirName = view.getName();
	    } catch (Exception ex) {
		if (Util.isLoggableWARNING()) {
		    Util.logWARNING(ex);
		}
		redirName = viewDesc.getName();
	    }

	    // Send redirect
	    try {
		ServletRequest req = ctx.getRequest();
		if (req.getAttribute(UNCAUGHT_REDIR) != null) {
		    // This isn't good, but we don't want an endless loop
		    return;
		}
		ctx.getRequest().setAttribute(UNCAUGHT_REDIR, "true");
		ctx.getResponse().sendRedirect(redirName);
	    } catch (Throwable ex) {
		if (Util.isLoggableWARNING()) {
		    Util.logWARNING(ex);
		}
	    }
	}
    }

    // Install a new formatter of log message; easier for debugging; not so good
    // for log reader tools, such as AdminGUI's logViewer.
    private void changeLogFileFormatter() {
        Handler[] h = LogUtil._logger.getHandlers();
        for (int i = 0; i < h.length; i++) {
            h[i].setFormatter(new PlainFormatter());
        }
    }

    /**
     *	This method should return a String URL pointing to the location of the
     *	XML file containing the ViewDescriptor definitions.
     */
    protected URL getViewXMLURL() {
        if (debug)
            changeLogFileFormatter();

	// Get the viewXML filename
        String viewXMLFile = ConfigProperties.getInstance().getViewXMLFileName();
	URL viewXML = null;

	// Attempt to load from the CLASSPATH
	viewXML = getClass().getClassLoader().getResource(viewXMLFile);

	// The following is mostly for development, XML file outside of the CP
	if (viewXML == null) {
	    if (Util.isLoggableFINEST()) {
		Util.logFINEST("Unable to find XML FILE in the CLASSPATH: " +
		    viewXMLFile);
	    }
            String sURL = "file:///" + 
                getServletConfig().getServletContext().getRealPath(viewXMLFile);
            try {
                viewXML = new URL(sURL);
            } catch (Exception exc) {
                throw new FrameworkException("Unable to create URL: '"+sURL+
			"' while attempting to locate '"+viewXMLFile+"'", exc);
            }
	}
	return viewXML;
    }

    protected EntityResolver getViewXMLEntityResolver() {
        if (entityResolver == null) {
            entityResolver = new ViewXMLEntityResolver();
        }
        return entityResolver;
    }
    
    /**
     *	This method should return a String to prefix before all JSP paths.
     *	This method may soon be deprecated, I recommend returning "" from this
     *	method to avoid problems later.
     */
    protected String getJSPRoot() {
        return AdminGUIConstants.DEFAULT_DISPLAY_URL_DIR;
    }


    /**
     *	@return The package name of the Servlet.
     */
    protected String getPackageName() {
	return PACKAGE_NAME;
    }


    public void init(ServletConfig config) throws ServletException {
	// Fix for CR# 6376475, the Admin GUI may not enter through the
	// login.jsp and therefor may not be initialized.  This fix ensures
	// the ViewDescriptors are loaded.  This MUST be done before
	// super.init() (or it will think its loaded already b/c init()
	// sets this stuff up.
	if (!PreloadXML.isAlreadyLoaded()) {
	    // Intentionally NOT running as a seperate Thread
	    new PreloadXML(config).run();
	}

	super.init(config);
	MODEL_TYPE_MAP = new ModelTypeMapImpl();
    }
    
    /* DEBUGGING METHODS.....
    private void printParams(HttpServletRequest request) {
        System.out.print("pathInfo: "+request.getPathInfo());
        System.out.print("contextPath: "+request.getContextPath());
        System.out.print("servletPath: "+request.getServletPath());
        System.out.print("user agent: "+request.getHeader("USER-AGENT"));
        System.out.println("");
        
        Enumeration enum = request.getParameterNames();
        while (enum.hasMoreElements()) {
            String name = (String) enum.nextElement();
            String value = request.getParameter(name);
            System.out.print("ReqParam: "+name+"="+value);
        }
        System.out.println("");
        
        enum = request.getAttributeNames();
        while (enum.hasMoreElements()) {
            String name = (String) enum.nextElement();
            Object value = request.getAttribute(name);
            System.out.print("ReqAttr: "+name+"="+value);
        }
        System.out.println("");
        
        enum = getServletConfig().getServletContext().getInitParameterNames();
        while (enum.hasMoreElements()) {
            String name = (String) enum.nextElement();
            String value = request.getParameter(name);
            System.out.print("initParam: "+name+"="+value);
        }
        System.out.println("");
    }
    */

    /* setup some config parameters - this would typically be used to control 
     * configuration across different versions of the product */
    protected void setupConfig() {
        ConfigProperties config = ConfigProperties.getInstance();
        config.setViewXMLFileName("xml/viewDescriptor.xml");
        config.setTreeXMLFileName("xml/treeDescriptor.xml", "index");
        config.setDefaultDisplayURLDir("/jsp/");
        config.setTargetSupported(new Boolean(false));
        config.setInitialRightPage("homePageFrameset");
        config.setLoggerName("javax.enterprise.system.tools.admin");
        config.setDefaultTarget("server");
        config.setConsoleTitleKey("common.consoleTitlePE");
    }
    
    protected void onBeforeRequest(RequestContext requestContext) 
    throws javax.servlet.ServletException {
        HttpSession session = requestContext.getRequest().getSession();
        if (session != null) {
            try {
                String timeOutSet = (String)session.getAttribute("AdminGUItimeOut");
                if (timeOutSet == null) {
                    session.setAttribute("AdminGUItimeOut", "true");
                    CommonHandlers.setTimeOut(requestContext);
                    // We have a new session. Maybe from a session timeout, then
                    // need to redirect to index.html so that all frames will be drawn.
                    //onSessionTimeout(requestContext);
                }
            } catch (CompleteRequestException cre) {
                throw new CompleteRequestException();
            } catch (Exception ex) {
                // log any error and keep going ....
                if (Util.isLoggableINFO()) {
                    Util.logINFO(ex);
                }
            }
        }
    }

    protected void onNewSession(RequestContext requestContext) throws ServletException {
        super.onNewSession(requestContext);
        CommonHandlers.setTimeOut(requestContext);
    }
        
    protected void onSessionTimeout(RequestContext requestContext) throws javax.servlet.ServletException {
	try {
	    String fileName = Util.getLocalizedHTML(requestContext, "/index.html");
	    requestContext.getResponse().sendRedirect(".."+fileName);
	} catch (IOException ex) {
	    if (Util.isLoggableWARNING()) {
		Util.logWARNING(ex);
	    }
	} catch (IllegalStateException ex) {
	    if (Util.isLoggableWARNING()) {
		Util.logWARNING(ex);
	    }
	}
	throw new CompleteRequestException();
    }


    ////////////////////////////////////////////////////////////////////////////////
    // Servlet methods
    ////////////////////////////////////////////////////////////////////////////////

    /**
     *
     *
     */
    protected void initializeRequestContext(RequestContext requestContext) {
	super.initializeRequestContext(requestContext);
	
	try {
		//fix for bugid: 6196436. We can move this fix to sun-web.xml after this release.
		HttpServletRequest request = requestContext.getRequest();
		if(request != null) {
			request.setCharacterEncoding("UTF-8");

			if(request.isSecure()) {
			    CCPrivateConfiguration.setSecurePort(request.getServerPort());
			    CCPrivateConfiguration.setSecureHelp(true);
			}
		}
	}
	catch(UnsupportedEncodingException ex) {
		if(Util.isLoggableWARNING()) {
			Util.logWARNING(ex);
		}
	}

	// Set a model manager in the request context.  This must be 
	// done at the application level because the MODEL_TYPE_MAP 
	// is application specific.
	com.sun.enterprise.tools.guiframework.model.ModelManager modelManager =
	    new com.sun.enterprise.tools.guiframework.model.ModelManager(
		requestContext, MODEL_TYPE_MAP);
	((RequestContextImpl)requestContext).setModelManager(modelManager);
    }


    /**
     *
     *
     */
    public String getModuleURL() {
	// The superclass can be configured from init params specified at
	// deployment time.  If the superclass has been configured with
	// a different module URL, it will return a non-null value here.
	// If it has not been configured with a different URL, we use our
	// (hopefully) sensible default.
	String result=super.getModuleURL();
	if (result != null) {
	    return result;
	}
	return DEFAULT_MODULE_URL;
    }
        
    public static final String DEFAULT_MODULE_URL = "../admingui";
    public static String PACKAGE_NAME=getPackageName(AdminGUIServlet.class.getName());
    protected static final String UNCAUGHT_REDIR = "__uncaughtRedirFlag";

    protected EntityResolver entityResolver;
    protected static ModelTypeMap MODEL_TYPE_MAP;

    // FIXME: Currently the logging backend is broken such that there is no
    // FIXME: way to set the this log level via the GUI, so for now I am
    // FIXME: hard-coding the Level here.
    static {
        if (debug)
            com.sun.enterprise.tools.guiframework.util.LogUtil.setLevel(
                com.sun.enterprise.tools.guiframework.util.LogUtil.FINER);
        else 
            com.sun.enterprise.tools.guiframework.util.LogUtil.setLevel(
                com.sun.enterprise.tools.guiframework.util.LogUtil.WARNING);
    }
}
