/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;

import com.sun.web.ui.model.CCTabsModelInterface;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;

import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCTabsDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.util.PermissionChecker;

import java.util.List;
import java.util.Map;

import javax.servlet.ServletRequest;


/**
 *
 *
 *  @author	Garrett Short, garrett.short@sun.com
 *  @author	Ken Paulsen, ken.paulsen@sun.com
 */
public class TabsDescriptor extends CCTabsDescriptor {

    /**
     *	Constructor
     */
    public TabsDescriptor(String name) {
	super(name);
    }
    
    /**
     *
     */
    protected int buildTabs(RequestContext ctx, CCTabsModelInterface model, List tabs, CCNavNodeInterface parent, int id) {
        if ((tabs == null) || (tabs.size() == 0)) {
            return id;
        }
	//making this call here to hid a single tabhref based on target is supported, or not.
	Boolean isTargetSupported = 
            ConfigProperties.getInstance().getTargetSupported();
        String currViewName = getParent().getName();

	// Add each Tab, and each tab's children
        for (int index=0; index<tabs.size(); index++) {
            ViewDescriptor tab = (ViewDescriptor)tabs.get(index);
            if (tab.getName().equals("TabHref")) {
                // "TabHref" is a Lockhart hard-code name. It is the name of the
                // hrefs used to construct the tabs component. A view Descriptor
                // may be defined for this href for processing events on the 
                // href itself. If this view descriptor is present, ignore it
                // in this tab processing.
                continue;
            }
	    //Right now this is used only in Deploy Page target tab, so hard coding the name here. We may have to get this
	    // from the xml file.
	    if(isTargetSupported != null && !(isTargetSupported.booleanValue()) && tab.getName().equals("DeployTargetTab")) {
		continue;
	    }
            Object expr = tab.getParameter("if");
            if (expr != null) {
                if (expr instanceof Boolean) {
                    if (((Boolean)expr).booleanValue() == false)
                        continue;
                } else if (expr instanceof String) {
                    if (new PermissionChecker((String)expr, tab).hasPermission() == false)
                        continue; // skip this tab.
                }
            }
            String label	= (String)tab.getParameter("label");
            String tooltip	= (String)tab.getParameter("tooltip");
            String status	= (String)tab.getParameter("status");
            String tabPage	= (String)tab.getParameter("nextPage");
            String target	= (String)tab.getParameter("target");
            if (label == null || tabPage == null) {
                throw new RuntimeException("Missing required parameters (label, nextPage) in tab declaration: "+
                    tab.getName()+", in view: "+currViewName, null);
            }
            CCNavNode node = new CCNavNode(id, parent, label, tooltip, status);
	    if ((target != null) && !(target.trim().equals(""))) {
		node.setTarget(target);
	    }
            if (parent == null) {
                model.addNode(node);
	    }
            if ((tabPage != null) && !(tabPage.equals(""))) {
		ServletRequest request = ctx.getRequest();
		((Map)request.getAttribute(VIEW_BEAN_MAP)).put(""+id, tabPage);
                if (tabPage.equals(currViewName)) {
		    request.setAttribute(CURR_TAB_ID, new Integer(id));
		}
            }
            id++;
            id = buildTabs(ctx, model, tab.getChildDescriptors(), node, id);
        }
        return id;
    }

}
