/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.command.CommandEvent;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ContainerViewBase;

import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModelImpl;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.util.Util;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewHelper;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.DisplayFieldDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.util.EventObject;
import java.util.Map;

public class BreadCrumbHandler {
    /**
     *	This event handler method processes a "click" on one of the bread crumb
     *	path components. (NOTE: This is used from CCBreadCrumbsDescriptor.java)
     */
    public void handleClick(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        
	// This allows us to pull information from the DisplayFieldDescriptor
	Map params = ((CommandEvent)handlerCtx.getEvent()).getParameters();
	DisplayFieldDescriptor desc = (DisplayFieldDescriptor)params.get(
		DescriptorViewHelper.COMMAND_FIELD_DESCRIPTOR);
        
        ViewBean vb = com.sun.enterprise.tools.guiframework.util.Util.getParentViewBean(view);
        ViewDescriptor vd = handlerCtx.getViewDescriptor();
        ((ContainerViewBase)vb).removeChild(vd.getParent().getName());
        
	// Get the "treeNode"
	String nodeName = (String)desc.getParameter("treeNode");
	if (nodeName != null) {
	    try {
		IndexTreeModel treeModel = Util.getCurrentTreeModel();
                                    //IndexTreeModelImpl.getIndexTreeModel(ctx);
		IndexTreeNode node = treeModel.getNode(nodeName);
		if (node != null) {
		    node.handleSelection(ctx);
		    return;
		}
	    } catch (Exception ex) {
		throw new FrameworkException(
		    "Error in locating the tree node.", ex,
		    (view instanceof DescriptorContainerView) ?
		    ((DescriptorContainerView)(view)).getViewDescriptor() :
		    null, view);
	    }
	}

	if (Util.isLoggableINFO()) {
	    Util.logINFO("BreadCrumbHandler.handleClick: No page set to forward to.");
	}

	// Get the containing ViewBean
	while (!(view instanceof ViewBean)) {
	    view = view.getParent();
	}
	if (view == null) {
	    throw new FrameworkException(
		"Unable to locate parent ViewBean!", desc, null);
	}
	((ViewBean)view).forwardTo(ctx);
    }
}
