/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.*;
import com.iplanet.jato.model.*;
import com.iplanet.jato.view.*;
import com.iplanet.jato.view.event.*;
import com.iplanet.jato.view.html.*;
import com.iplanet.jato.util.NonSyncStringBuffer;

import com.sun.web.ui.taglib.header.*;
import com.sun.web.ui.taglib.pagetitle.*;
import com.sun.web.ui.common.CCI18N;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;

import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Iterator;

import com.sun.enterprise.tools.admingui.ConfigProperties;

public class HtmlHeaderHandler {
    
    private boolean refreshForOpenNodes(RequestContext ctx) {
        IndexTreeNode node = Util.getSelectedNode();
        if (node == null)
            return false;
        
        node = node.getParent();
        if (node == null)
            return false;
        
        // open the parent of the selection node, return true if
        // anything changed.
        return node.openNode(ctx);
    }
    
    private void setHeaderDisplayValues(CCHtmlHeaderTag tag, HandlerContext handlerCtx) {
        String onUnload = (String)handlerCtx.getInputValue("onUnload");
        if (onUnload != null)
            tag.setOnUnload(onUnload);
        
        String copyRight = (String)handlerCtx.getInputValue("copyRight");
        if (copyRight != null)
            tag.setCopyrightYear(copyRight);
        
        String title = (String)handlerCtx.getInputValue("pageTitle");
        if (title != null)
            tag.setPageTitle(title);
    }
    
    public void beginHtmlHeaderDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd = handlerCtx.getViewDescriptor();
        if (vd.getParent() != null)
            vd = vd.getParent(); // look for descriptor at the view bean level.
        Iterator it = vd.getChildDescriptors().iterator();
        String tableButtonInitScript = "";
        while (it.hasNext()) {
            ViewDescriptor child = (ViewDescriptor)it.next();
            if (child instanceof CCActionTableDescriptor) {
                tableButtonInitScript = 
                    (String)handlerCtx.getInputValue("tableButtonInitScript");
                //    "javascript: if (toggleDisabledState) toggleDisabledState(); ";
                break;
            }
        }
	if (tableButtonInitScript == null) {
	    tableButtonInitScript = "";
	}
        
        CCHtmlHeaderTag tag = (CCHtmlHeaderTag)handlerCtx.getEvent().getSource();
        
        boolean refresh = ctx.getRequest().getAttribute("refreshTree") != null;
	String onLoad = null;
        if (refreshForOpenNodes(ctx) || refresh) {            
            onLoad = (String)handlerCtx.getInputValue("onLoadRefreshTree");
        } else {
            onLoad = (String)handlerCtx.getInputValue("onLoad");
        }
	if (onLoad != null) {
	    tag.setOnLoad(tableButtonInitScript+onLoad);
	}
        setHeaderDisplayValues(tag, handlerCtx);
    }
    
    public void beginTreeHtmlHeaderDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCHtmlHeaderTag tag = (CCHtmlHeaderTag)handlerCtx.getEvent().getSource();
        
        boolean refresh = ctx.getRequest().getAttribute("refreshRightSide") != null;
        if (refresh) {            
            String onLoad = (String)handlerCtx.getInputValue("onLoadRefreshRight");
            if (onLoad != null)
                tag.setOnLoad(onLoad);
        } else {
            String onLoad = (String)handlerCtx.getInputValue("onLoad");
            if (onLoad != null)
                tag.setOnLoad(onLoad);
        }
        ctx.getRequest().removeAttribute("refreshRightSide"); // probaby not needed.
        setHeaderDisplayValues(tag, handlerCtx);
    }
    

    private static CCI18N peHelpIds = null;
    private static CCI18N eeHelpIds = null;
    
    private static String getHelpHTMLName(String key) {
        Boolean isEE = ConfigProperties.getInstance().getTargetSupported();
        if (isEE.booleanValue() && eeHelpIds == null) {
            eeHelpIds = new CCI18N(RequestManager.getRequestContext(), 
                "com.sun.enterprise.ee.tools.admingui.resources.Helplinks");
        }
        if (peHelpIds == null) {
            peHelpIds = new CCI18N(RequestManager.getRequestContext(), 
                "com.sun.enterprise.tools.admingui.resources.Helplinks");
        }
        String htmlFileName = null;
        if (eeHelpIds != null) {
            htmlFileName = eeHelpIds.getMessage(key);
            if (htmlFileName.equals(key))
                htmlFileName = null; // not really found.
        }
        if (htmlFileName == null) {
            htmlFileName = peHelpIds.getMessage(key);
        }
        if (htmlFileName != null) {
            htmlFileName = htmlFileName.trim();
        }
        if (htmlFileName == null || htmlFileName.length() == 0 || htmlFileName.equals(key)) {
            htmlFileName = peHelpIds.getMessage("default");
        }
        if (htmlFileName != null) {
            htmlFileName = htmlFileName.trim();
        }
        if (htmlFileName == null || htmlFileName.equals("")) {
            htmlFileName = key;
        }
        if (htmlFileName.endsWith(".html") == false) {
            htmlFileName += ".html";
        }
        return htmlFileName;            
    }
    
    private void addHiddenAttrValue(NonSyncStringBuffer buff, RequestContext ctx, 
            IndexTreeNode node, String attrName, boolean lookUpInTreeHierarchy) {
        String attr = null;
        Object obj = node.getAttribute(attrName, lookUpInTreeHierarchy);
        if (obj == null) // values propagated if the user clicks the back button
            obj = ctx.getRequest().getAttribute(attrName);
        // no encod
        if (obj != null)
            //attr = Util.URLencode(ctx, obj.toString());
            attr = obj.toString();
        if (attr != null && attr.length() > 0) {
            buff.append("\n<input name=\"")
                .append(attrName)
                .append("\" type=\"hidden\" value=\"")
                .append(attr).append("\">");
        }
    }
    
    private void setCurrentView(RequestContext ctx, View view) {
        // When refreshing a page from switching tree views, the state
        // information can be retrieved from the current node of tree, except
        // for 'editKeyValue' which some pages need in order to draw. 
        String currentView = view.getName();
        String editKeyValue = (String)ctx.getRequest().getAttribute("editKeyValue");
        if (editKeyValue != null) 
            currentView += "?editKeyValue="+Util.URLencode(ctx, editKeyValue);
        
        Util.setCurrentViewURL(currentView);
    }
    
    // add a hidden variable for the highlight ID and include javascript
    public String endExtraDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
	View bean = handlerCtx.getView();

	while (!(bean instanceof DescriptorContainerView)) {
	    // Should only happen once, if at all.
	    bean = bean.getParent();
	}
        // remember the current view (page) so we can go back to it when switching trees.
        setCurrentView(ctx, bean);

        NonSyncStringBuffer buff = new NonSyncStringBuffer(ev.getContent(), 512);
        
        String script = (String)handlerCtx.getInputValue("script") ;
        if (script != null) {
            buff.append("\n").append(script);
	}

        
	IndexTreeNode selectedNode = Util.getSelectedNode();
        if (selectedNode != null) {
            String id = selectedNode.getHighlightIDPath();
            buff.append("\n<input name=\"highlightid\" type=\"hidden\" value=\"")
                .append(id).append("\">");
            
            addHiddenAttrValue(buff, ctx, selectedNode, IndexTreeNode.INSTANCE_NAME, true);
            addHiddenAttrValue(buff, ctx, selectedNode, IndexTreeNode.CONFIG_NAME, true);
            addHiddenAttrValue(buff, ctx, selectedNode, IndexTreeNode.CLUSTER_NAME, true);
            addHiddenAttrValue(buff, ctx, selectedNode, IndexTreeNode.NODEAGENT_NAME, true);
            addHiddenAttrValue(buff, ctx, selectedNode, IndexTreeNode.APPLICATION_TYPE, true);
            addHiddenAttrValue(buff, ctx, selectedNode, IndexTreeNode.OBJECT_NAME, false);
        }
        
        String helpID = (String)handlerCtx.getInputValue("helpID") ;
        if (helpID == null)
            helpID = bean.getName();
        String helpHTMLName = getHelpHTMLName(helpID);
        buff.append("\n<input name=\"helplink\" type=\"hidden\" value=\"")
            .append(helpHTMLName).append("\">");
        
        return buff.toString();
    }

    public String endResourceStringsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String keys = ev.getContent();
        if (keys == null | keys.length() == 0)
            return "";
        
        String result = "";
        StringTokenizer st = new StringTokenizer(keys);
        while (st.hasMoreTokens()) {
            String key = st.nextToken().trim();
            if (key.length() == 0)
                continue;
            result += "<input name=\"" + key + "\" type=\"hidden\" value=\"" +
                        Util.getMessage(key) + "\">\n";
        }
        return result;
    }
       
     public void beginLinksPageTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
         CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
         IndexTreeNode selectedNode = Util.getSelectedNode();
         tag.setPageTitleText(selectedNode.getName());
     }

     public String endChildPageLinkDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        final String hrefExtras = "title=\"@@@@\" " +
            "onmouseover=\"window.status='@@@@'; return true\" " +
            "onmouseout=\"window.status=''; return true\" " +
            "onblur=\"window.status=''; return true\" " +
            "onfocus=\"window.status='@@@@'; return true\" ";

        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String html = ev.getContent();
        String replace = (String)handlerCtx.getInputValue("replace");
        if (Util.isEmpty(replace))
            replace = "links";
	IndexTreeNode selectedNode = Util.getSelectedNode();
        if (selectedNode != null) {
            // don't need the name.
            html = Util.removeHtmlProp(html,  "name"); 
            // change the href location...
            html = html.replaceAll(replace, "Index");
            html = html.replaceAll("childPageLink", "TreeView1.showContainer");
            
            // get the child index
            int i = html.indexOf("__");
            int j = html.indexOf("__", i+2);
            if (i < 0 || j < 0) 
                return "";
            int index = new Integer(html.substring(i+2, j)).intValue();

            // put the child specific info into the tag
            IndexTreeNode kid = (IndexTreeNode)selectedNode.getChildren().get(index);
            if (kid == null)
                return "";
            html = html.replaceAll(html.substring(i, j+2), kid.getName());
            html = html.replaceAll("_VALUE_", kid.getPath());
            
            html = Util.addHtmlProp(html, hrefExtras.replaceAll("@@@@", kid.getName()));
            return html;
        }
        return "";
    }

}
