/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.ArrayList;
import java.util.EventObject;

import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;

import com.sun.web.ui.model.CCActionTableModelInterface;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;


public class JVMOptionsHandler {

    private CCActionTableModelInterface getModel(HandlerContext handlerCtx, ViewDescriptor desc) {
        CCActionTableModelInterface model =
            (CCActionTableModelInterface)handlerCtx.getInputValue("model");
        model.setRowSelectionType("multiple");

        if (model == null) {
            throw new FrameworkException("JVMOptionsHandler.getModel: No Model Specified.",
                desc, handlerCtx.getView());
        }
        return model;
    }

    private void loadModel(CCActionTableModelInterface model, String [] list) throws ModelControlException {
        model.beforeFirst();
        for(int rowNo = 0; rowNo < list.length; rowNo++) {
            model.appendRow();
            model.setValue(PROPERTY_VALUE, list[rowNo]);
            model.setRowSelected(false);
        }
    }

    public void populateModel(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
	} else {
            DescriptorContainerView descView = (DescriptorContainerView)
                (((ViewBase)view).getParentViewBean());
            desc = descView.getViewDescriptor();
        }

        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        String[] jvmOptions = null;
        try {
            jvmOptions = (String[])MBeanUtil.getAttribute(new ObjectName(objectName), ATTRIBUTE_NAME);
        } catch (Exception ex) {
            // the above method will throw an exception when the object doesn't exist to get the attr.
            return;
            //throw new FrameworkException("populatePropsTableModel: Loading error. ", ex,
            //   desc, view);
        }

        try {
            CCActionTableModelInterface model = getModel(handlerCtx, desc);
            ((DefaultModel)model).clear();
            loadModel(model, jvmOptions);
        } catch (Exception ex) {
            throw new FrameworkException("populatePropsTableModel: Loading error. ", ex,
                desc, view);
        }
    }

    public void addProperty(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();

	try {
	    CCActionTableModelInterface model = getModel(handlerCtx, vd);
	    model.appendRow();
	    model.setValue(PROPERTY_VALUE, "");
	    model.beforeFirst();
        } catch (Exception ex) {
            throw new FrameworkException("JVMOptionsHandler.addProperty: ", ex,
                vd, view);
	}
    }


    public void updateOptions(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();

        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        CCActionTableModelInterface model = getModel(handlerCtx, vd);
	ArrayList options = new ArrayList();

	try {
            model.beforeFirst();
            while(model.next()) {
                String value = (String) model.getValue(PROPERTY_VALUE);
                if (value != null && (! value.trim().equals(""))) {
                    options.add(value);
                    model.setRowSelected(false);
                }
            }
            String[] jvmOptions = (String[])options.toArray(new String[0]);
            //set the new values
            Attribute attr = new Attribute(ATTRIBUTE_NAME, jvmOptions);
            MBeanUtil.setAttribute(objectName, attr);

            ((DefaultModel)model).clear();
            // The model will be reloaded from the backend on the beginDisplay Event
        } catch (Exception ex) {
            throw new FrameworkException("JVMOptionsHandler.updateOptions: ", ex,
                vd, view);
	}
    }

    public void deleteOptions(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();

        String objectName = (String)ctx.getRequest().getAttribute(OBJECT_NAME);
	//using the same method for both save, and delete based on the option clicked.

        CCActionTableModelInterface model = getModel(handlerCtx, vd);
	ArrayList options = new ArrayList();

	try {
            model.beforeFirst();
            while(model.next()) {
                String value = (String) model.getValue(PROPERTY_VALUE);
                if (value != null && (! value.trim().equals(""))) {
                    if (model.isRowSelected() == false) {
                        options.add(value);
                        //model.setRowSelected(false);
                    }
                }
            }
            String[] jvmOptions = (String[])options.toArray(new String[0]);
            ((DefaultModel)model).clear();
            loadModel(model, jvmOptions);
        } catch (Exception ex) {
            throw new FrameworkException("JVMOptionsHandler.deleteOptions: ", ex,
                vd, view);
	}
    }
    
    public void getSecurityManagerStatus(RequestContext ctx, HandlerContext handlerCtx) {
	
        String objectName = (String)handlerCtx.getInputValue("objectName");
        if (objectName == null){
             throw new FrameworkException("JVMOptionsHandler.getSecurityManagerStatus requires INPUT objectName");
        }
                
        Boolean status = isSecurityManagerEnabled(objectName);
        handlerCtx.setOutputValue("securityManagerEnabled", status.toString());
    }
    
    
    private Boolean isSecurityManagerEnabled(String objectName){
        String[] jvmOptions = null;
        try {
            jvmOptions = (String[])MBeanUtil.getAttribute(new ObjectName(objectName), ATTRIBUTE_NAME);
            if (jvmOptions != null){
                for(int i=0; i< jvmOptions.length; i++){
                    if (jvmOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) ||
                            jvmOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)){
                        return Boolean.TRUE;
                    }
                }
            }
        } catch (Exception ex) {
            // the above method will throw an exception when the object doesn't exist to get the attr.
        }
        return Boolean.FALSE;
    }
    
    
    public void setSecurityManager(RequestContext ctx, HandlerContext handlerCtx) {
	
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String value = (String)handlerCtx.getInputValue("value");
        if (objectName == null || value == null){
             throw new FrameworkException("JVMOptionsHandler.setSecurityManager requires INPUT objectName and value");
        }
        Boolean status = isSecurityManagerEnabled(objectName);
        Boolean userValue = new Boolean(value);
        if (status.equals(userValue)){
            //no need to change
            return;
        }
        ArrayList newOptions = new ArrayList();
        try {
            String[] origOptions = (String[])MBeanUtil.getAttribute(new ObjectName(objectName), ATTRIBUTE_NAME);
            if(userValue){
                for(int i=0; i<origOptions.length; i++){
                    newOptions.add(origOptions[i]);
                }
                newOptions.add(JVM_OPTION_SECURITY_MANAGER);
            }else{
                for(int i=0; i<origOptions.length; i++){
                    if (! (origOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) ||
                            origOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL))){
                       newOptions.add(origOptions[i]);
                    }
                }
            }
            
        } catch (Exception ex) {
            // the above method will throw an exception when the object doesn't exist to get the attr.
        }
        String[] jvmOptions = (String[])newOptions.toArray(new String[0]);
        //set the new values
        Attribute attr = new Attribute(ATTRIBUTE_NAME, jvmOptions);
        MBeanUtil.setAttribute(objectName, attr);
    }

    //viewxml file Attribute Names
    public static final String	OBJECT_NAME 	= "objectName";
    //DisplayField Name
    public static final String	PROPERTY_VALUE 	= "propertyValue";
    //mbean Attribute Name
    private static final String ATTRIBUTE_NAME   = "jvm-options";
    
    private static final String JVM_OPTION_SECURITY_MANAGER = "-Djava.security.manager";
    private static final String JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL = "-Djava.security.manager=";
}
