/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * CommonHandlers.java
 *
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Properties;
import java.util.Enumeration;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.RootCauseException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.DisplayFieldImpl;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.model.ModelControlException;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;
import javax.servlet.ServletRequest;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;

import com.sun.web.ui.model.CCActionTableModelInterface;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;


public class JmsHandlers {

    public static final String	PROPERTY_NAME	= "propertyName";
    public static final String	PROPERTY_VALUE 	= "propertyValue";
    
    public void loadJmsPhysicalDestinations(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	if (!(handlerCtx.getEvent() instanceof BeforeCreateEvent)) {
	    ViewDescriptor desc = (view instanceof DescriptorContainerView) ?
		((DescriptorContainerView)view).getViewDescriptor() :
		(ViewDescriptor)null;
	    throw new FrameworkException("This handler is for 'beforeCreate'" +
		" handlers only!", desc, view);
	}
            
        ViewDescriptor desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        if (!(desc instanceof CCActionTableDescriptor)) {
	    throw new FrameworkException("Table model expected here", desc, view);
        }
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        CCActionTableModelInterface model = ccDesc.getModel();
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String configName = (String)handlerCtx.getInputValue("configName");
        
        ObjectName[] objectNames = null;
        String [] params = {configName};
        String [] types = {"java.lang.String"};
        try{
            objectNames = (ObjectName[])MBeanUtil.invoke(objectName, methodName, params, types);
        }catch (Exception ex){
            //There maybe problem connecting to the MQ server, just report the exception got from backend
            handlerCtx.setOutputValue("hasError", "true");
            Throwable upper = ex.getCause();    //bypass the FrameworkException
            handlerCtx.setOutputValue("errorMsg", upper.getCause());
            ex.printStackTrace();
            return;
        }
        
        if (objectNames == null) {
            return; //nothing to load..
	}
        for (int i = 0; i < objectNames.length; i++) {
            // getAttributes for the given objectName...
            model.appendRow();            
            model.setValue("name", objectNames[i].getKeyProperty("destName"));
            model.setValue("type", objectNames[i].getKeyProperty("destType"));
        }
    }
    public void physicalDestinationActions(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)(((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
	String childName = (String)vd.getParameter("tableChildName");
	if(childName == null) {
	    throw new FrameworkException("deleteHandler: childName not specified", vd, view);
	}
        
	ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
	if(tableDescriptor == null) {
	    throw new FrameworkException("deleteHandler: tableDescriptor is null", vd, view);
	}
	if(!(tableDescriptor instanceof CCActionTableDescriptor)) {
	    throw new FrameworkException("deleteHandler: tableDescriptor is of wrong type", tableDescriptor, view);
	}
        CCActionTableModelInterface model = ((CCActionTableDescriptor)tableDescriptor).getModel();
	String methodName = (String)handlerCtx.getInputValue("methodName");
	String objectName = (String)handlerCtx.getInputValue("objectName");
	String target = (String)handlerCtx.getInputValue("target");
	if(objectName == null) {
	    throw new FrameworkException("No ObjectName  specified");
	}
	model.setRowSelectionType("multiple");
	try {
	    model.beforeFirst();
	    // from the model, get the child that has the needed value...
	    while(model.next()) {
		if (model.isRowSelected()) {
                    Object[] params = new Object[]{
                        model.getValue("name"), 
                        model.getValue("type"), 
                        target};
                    String[] types = new String[]{
                        "java.lang.String", 
                        "java.lang.String", 
                        "java.lang.String"};
                    MBeanUtil.invoke(objectName, methodName, params, types);
		    model.setRowSelected(false);
                }
            }
	} catch (Exception ex) {
	    throw new FrameworkException(ex);
        }
	ContainerViewBase containerView = (ContainerViewBase)(tableDescriptor.getView(ctx).getParent());
	containerView.removeChild(tableDescriptor.getName());
	((DefaultModel)model).clear();
    }
    
    /*
    public void getJmsConnectionStatus(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)(view.getParent());
        String objectName = "ias:type=connector-resource,category=config,jndi-name=" +
            descView.getDisplayFieldValue("editKey");
	try {
	    descView.setDisplayFieldValue("ResourceEnabled", 
		MBeanUtil.getAttribute(new ObjectName(objectName), "enabled"));
	} catch (Exception ex) {
	    throw new FrameworkException(
		ex, descView.getViewDescriptor(), view);
	}
    }
    
    public void setJmsConnectionStatus(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)(view.getParent().getParent());
        String objectName = "ias:type=connector-resource,category=config,jndi-name=" +
            descView.getDisplayFieldValue("editKey");
        Attribute attr  = 
            new Attribute("enabled", descView.getDisplayFieldValue("ResourceEnabled"));
        MBeanUtil.setAttribute(objectName, attr);
    }
    
    */
    
}
