/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;


import javax.servlet.http.HttpSession;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.html.CCOptionGroup;
import com.sun.web.ui.view.html.CCOptionSeparator;

import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.ConfigProperties;


import java.util.logging.LogManager;
import java.util.Enumeration;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;

import static com.sun.enterprise.admin.selfmanagement.event.ManagementRuleConstants.*;


public class ManagementRulesHandler {
   static final String PROPERTY_NOTIFICATION_TYPE="type";
   
   
    public void loadManagementRulesTable(RequestContext ctx, HandlerContext handlerCtx) {
        
//        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
//        CCActionTableModelInterface model = ccDesc.getModel();
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        String objectName = (String) handlerCtx.getInputValue("objectName");
        String methodName = (String) handlerCtx.getInputValue("methodName");
        String eventObjectName = (String) handlerCtx.getInputValue("eventObjectName");
         
        try{
            model.setRowSelectionType("multiple");
            model.beforeFirst();
            ObjectName[] rules = (ObjectName[] ) MBeanUtil.invoke(objectName, methodName, null, null);
            
            for(int i=0; i< rules.length; i++){
                model.appendRow();
                String ruleName=  rules[i].getKeyProperty("name");
                model.setValue("name", ruleName);
                model.setValue("ruleObjectName", rules[i]);
                String enabled = (String) MBeanUtil.getAttribute( rules[i], "enabled");
                model.setValue("status", "true".equals(enabled)? Util.getMessage("common.Enabled") : Util.getMessage("common.Disabled"));
                String eventType = (String) MBeanUtil.getAttribute(eventObjectName+ruleName, "type");
                model.setValue("eventType", eventType);
                
                
            }
            
        }catch(Exception ex){
            Util.logFINE(ex);
        }
    }
    
    
    public void managementRulesDelete(RequestContext ctx, HandlerContext handlerCtx) {
        
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
//        ((DefaultModel)model).dumpValues(System.out);
        
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String deleteMethod = (String) handlerCtx.getInputValue("deleteMethod");
        
        model.setRowSelectionType("multiple");
        try{
            model.beforeFirst();
            
            while(model.next()) {
                boolean selected = model.isRowSelected();
                if (selected) {
                    String ruleObjectName = (String) model.getValue("ruleObjectName");
                    ObjectName objN = new ObjectName(ruleObjectName);
                    String params[]={objN.getKeyProperty("name")};
                    String types[] = {"java.lang.String"};
                    MBeanUtil.invoke(objectName, deleteMethod, params, types);
                    model.setRowSelected(false);
                }
            }
        }catch(Exception ex) {
            ex.printStackTrace();
	    throw new FrameworkException("Unable to  delete Management Rule:", ex);
	}
    }
    
    public void managementRulesChangeStatus(RequestContext ctx, HandlerContext handlerCtx) {
        
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
//        ((DefaultModel)model).dumpValues(System.out);
        
        String enabled = (String) handlerCtx.getInputValue("enabled");
        model.setRowSelectionType("multiple");
        try{
            model.beforeFirst();
            while(model.next()) {
                boolean selected = model.isRowSelected();
                if (selected) {
                    String ruleObjectName = (String) model.getValue("ruleObjectName");
                     MBeanUtil.setAttribute(ruleObjectName, new Attribute("enabled", enabled));
                     model.setRowSelected(false);
                }
            }
        }catch(Exception ex) {
            ex.printStackTrace();
	    throw new FrameworkException("Unable to set enable status ", ex);
	}
    }
    
    public void populateEventTypes(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        
        OptionList optionList = new OptionList();
        optionList.add("", "");
        
        optionList.add(EVENT_MONITOR, EVENT_MONITOR);
        optionList.add(new CCOptionSeparator());
        optionList.add(EVENT_NOTIFICATION, EVENT_NOTIFICATION);
         optionList.add(new CCOptionSeparator());
        CCOptionGroup og = new CCOptionGroup(Util.getMessage("managementRules.systemEvent"), "---");
        og.add(new CCOption(EVENT_LIFECYCLE, EVENT_LIFECYCLE));
        og.add(new CCOption(EVENT_LOG, EVENT_LOG));
        og.add(new CCOption(EVENT_TIMER , EVENT_TIMER));
        og.add(new CCOption(EVENT_TRACE ,EVENT_TRACE));
        
        Boolean isEE = ConfigProperties.getInstance().getTargetSupported();
        if (isEE.booleanValue())
            og.add(new CCOption(EVENT_CLUSTER , EVENT_CLUSTER));
        og.add(new CCOption("  " ,""));
        
        optionList.add(og);
        dropDownChild.setOptions(optionList);
    }
    
    
    public void populateActions(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        String objectName = (String) handlerCtx.getInputValue("objectName");
        Object[] params = {Boolean.FALSE};
        String[] types = {"boolean"};
        List<String> actionBeansList = (List) MBeanUtil.invoke(objectName, "getAllActionMBeans", params, types);  
        if (actionBeansList == null) 
            return;
        
        OptionList optionList = new OptionList();
        optionList.add("         ", "");
        for (String  actionBeans : actionBeansList) {
            optionList.add(actionBeans, actionBeans);
        }
        dropDownChild.setOptions(optionList);
        
        String initialValue = (String)handlerCtx.getInputValue("initialValue");
        if (initialValue == null || initialValue.length() == 0) {
            //dropDownChild.setLabelForNoneSelected("    ");
	} else {
	    if (dropDownChild.getValue() == null) {
		dropDownChild.setValue(initialValue);
	    }
	}
    }
    
    public void populateLogLevels(RequestContext ctx, HandlerContext handlerCtx) {
         populateDropDownEventProperties(handlerCtx,  EVENT_LOG, PROPERTY_LOG_LEVEL );
     }
    
    public void populateLogger(RequestContext ctx, HandlerContext handlerCtx) {
         populateDropDownEventProperties(handlerCtx,  EVENT_LOG, PROPERTY_LOG_LOGGERNAME );
         
         //set Initial value, this is special case since multiple loggers may be selected.
         List <Attribute> eventProperties = (List) handlerCtx.getInputValue("eventProperties");
         if (eventProperties == null || eventProperties.size() < 1){
             return;
         }
         String loggers = null;
         for(Attribute attr :  eventProperties){
             if (PROPERTY_LOG_LOGGERNAME.equals(attr.getName())){
                 loggers = (String) attr.getValue(); 
                 break;
             }
         }
         if (loggers != null){
             String[] eachRow = loggers.split(",");
             if (eachRow != null & eachRow.length > 0){
                 SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
                 dropDownChild.setValues(eachRow);
             }
	}
     }
     
     
     public void populateLifeCycleNames(RequestContext ctx, HandlerContext handlerCtx) {
         populateDropDownEventProperties(handlerCtx,  EVENT_LIFECYCLE, PROPERTY_LIFECYCLE_NAME );
     }
     
     
     public void populateTraceNames(RequestContext ctx, HandlerContext handlerCtx) {
         populateDropDownEventProperties(handlerCtx,  EVENT_TRACE, PROPERTY_TRACE_NAME );
     }
     
    public void getEditPage(RequestContext ctx, HandlerContext handlerCtx) {
        String ruleObjectName = (String)handlerCtx.getInputValue("ruleObjectName");
        ObjectName eventObjectName = (ObjectName) MBeanUtil.invoke(ruleObjectName, "getEvent", null, null);
        String eventType = (String)MBeanUtil.getAttribute(eventObjectName, "type");
        String editPage = null;
        
        if (EVENT_TIMER.equals(eventType)){
            editPage = "managementRuleTimerEdit";
        }else
        if (EVENT_MONITOR.equals(eventType)){
                String type = (String) MBeanUtil.invoke(eventObjectName, "getPropertyValue",
                                new Object[]{PROPERTY_MONITOR_TYPE},  
                                new String[]{"java.lang.String"});
                if(PROPERTY_MONITOR_COUNTER.equals(type)){
                    editPage = "managementRuleMonitorCountEdit";
                }else
                if (PROPERTY_MONITOR_STRING.equals(type)){
                    editPage = "managementRuleMonitorStringEdit";
                }else
                    editPage = "managementRuleMonitorGaugeEdit";
        }else
        if (EVENT_CLUSTER.equals(eventType)){
            editPage = "managementRuleClusterEdit";
        }else
            if (eventType.equals(EVENT_LOG) ){
            editPage = "managementRuleLogEdit";
        }
        else
            if (eventType.equals(EVENT_NOTIFICATION) ){
            editPage = "managementRuleNotificationEdit";
        }
        else
            if (eventType.equals(EVENT_TRACE) ){
            editPage = "managementRuleTraceEdit";
        }
        else
            if (EVENT_LIFECYCLE.equals(eventType)){
            editPage = "managementRuleLifeCycleEdit";
        }
        handlerCtx.setOutputValue("editPage", editPage);
    }
    
    
    public void getNextCreationPage(RequestContext ctx, HandlerContext handlerCtx) {
        String out="";
        String eventSelected = (String)handlerCtx.getInputValue("eventType");
        
        if (EVENT_TIMER.equals(eventSelected)){
            out = "managementRuleTimer";
        }else
            if (EVENT_MONITOR.equals(eventSelected)){
            out = "managementRuleMonitor";
        }else
            if (EVENT_CLUSTER.equals(eventSelected) ){
            out = "managementRuleCluster";
        }else
            if (EVENT_LOG.equals(eventSelected) ){
            out = "managementRuleLog";
        }
        else
            if (EVENT_NOTIFICATION.equals(eventSelected)){
            out = "managementRuleNotification";
        }
        else
            if (EVENT_TRACE.equals(eventSelected)){
            out = "managementRuleTrace";
        }
        else
            if (EVENT_LIFECYCLE.equals(eventSelected)){
            out = "managementRuleLifeCycle";
        }else{
            throw new FrameworkException("Cannot determine the next step of New Management Rule. EventType not recognized");
        }
            
        handlerCtx.setOutputValue("nextPage", out);
    }
   
    public void createManagementRule(RequestContext ctx, HandlerContext handlerCtx) {
        
        String objectName = (String) handlerCtx.getInputValue("objectName");
	HttpSession session = RequestManager.getSession();
        String step1ModelName = (String) handlerCtx.getInputValue("step1Model");
        String step2ModelName = (String) handlerCtx.getInputValue("step2Model");
        
        DefaultModel step1Model = (DefaultModel)(session.getValue(step1ModelName));
        DefaultModel step2Model = (DefaultModel)(session.getValue(step2ModelName));
        String ruleName = (String)step1Model.getValue("Name");
        Boolean ruleEnabled = new Boolean((String)step1Model.getValue("enabled"));
        String ruleDesc = (String)step1Model.getValue("ruleDesc");
        String eventType = (String)step1Model.getValue("eventType");
        String eventLevel = (String)step1Model.getValue("eventLogLevel");
        Boolean eventRecordEvent = new Boolean((String)step1Model.getValue("recordEvent"));
        
        //Every step 2 model will have these 2 elements.
        String eventDesc = (String)step2Model.getValue("eventDesc");
        String actionMbean = (String)step2Model.getValue("actions");
        if(Util.isEmpty(actionMbean))
            actionMbean=null;
        
        Properties eventProps = null;
        //Get specific property for each eventtype
        if (EVENT_TIMER.equals(eventType)){
            eventProps = getTimerProperties(step2Model);
        }else
            if (EVENT_MONITOR.equals(eventType)){
            eventProps = getMonitorProperties(step2Model);
        }else
            if (EVENT_CLUSTER.equals(eventType) ){
                eventProps = getClusterProperties(step2Model);
        }else
            if (EVENT_LOG.equals(eventType) ){
                eventProps = getLogProperties(step2Model);
        }
        else
            if (EVENT_NOTIFICATION.equals(eventType)){
                eventProps = getNotificationProperties(step2Model);
        }
        else
            if (EVENT_TRACE.equals(eventType)){
                 eventProps = getTraceProperties(step2Model);
        }
        else
            if (EVENT_LIFECYCLE.equals(eventType)){
                eventProps = getLifeCycleProperties(step2Model);
        }
        
    
        Object[] params = { ruleName, ruleEnabled, ruleDesc,
                eventType, eventLevel, eventRecordEvent, eventDesc, eventProps,
                actionMbean};
        String[]types = {
            "java.lang.String", "java.lang.Boolean", "java.lang.String",
            "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.util.Properties",
            "java.lang.String"};
            
        MBeanUtil.invoke(objectName, "createManagementRule", params, types);
            
    }
    
         
    private void setProp(Properties props, String name, String value){
        if (!Util.isEmpty(value)){
            props.setProperty(name, value);
        }
    }
    
    private Properties getLogProperties(DefaultModel model){
        
        Object loggers = (Object) model.getValues("logger");
        String allLogger = "";
	if (loggers != null) {
	    int len = ((Object[])loggers).length;
	    for (int count=0; count<len; count++) {
		String val = (String) (((Object[])loggers)[count]);
		if ((val == null) || (val.toString().trim().length() == 0)) {
		    continue;
		}
		allLogger=allLogger+","+val;
	    }
	}
        
        String logLevel = (String) model.getValue("logLevel");
        Properties props =  new Properties();
        setProp(props, PROPERTY_LOG_LOGGERNAME, allLogger);
        setProp(props, PROPERTY_LOG_LEVEL, logLevel);
        return props;
    }
    
    private Properties getClusterProperties(DefaultModel model){
        
        String clusterEventName = (String) model.getValue("clusterEventName");
        String clusterEventServerName = (String) model.getValue("clusterEventServerName");
        Properties props =  new Properties();
        setProp(props, PROPERTY_CLUSTER_NAME, clusterEventName);
        setProp(props, PROPERTY_CLUSTER_SERVERNAME, clusterEventServerName);
        return props;
    }
    
    private Properties getNotificationProperties(DefaultModel model){
        
        Properties props =  new Properties();
        String selected = (String) model.getValue("sourceRB");
        if ("predefinedMBean".equals(selected)){
            String sourceMbean = (String) model.getValue("sourceMbean");
            setProp(props, PROPERTY_NOTIFICATION_SOURCEMBEAN, sourceMbean);
           
        }else{
            String sourceObjectName = (String) model.getValue("sourceObjectName");
            setProp(props, PROPERTY_NOTIFICATION_SOURCE_OBJ_NAME, sourceObjectName);
        }
        String type = (String) model.getValue("notificationType");
        setProp(props, PROPERTY_NOTIFICATION_TYPE,  type);
        return props;
    }
      
        
    private Properties getLifeCycleProperties(DefaultModel model){
        
        String lifeCycleName = (String) model.getValue("lifeCycleName");
        Properties props =  new Properties();
        setProp(props, PROPERTY_LIFECYCLE_NAME, lifeCycleName);
        return props;
    }
    
    
    private Properties getTraceProperties(DefaultModel model){
        Properties props =  new Properties();
        setProp(props, PROPERTY_TRACE_NAME, (String) model.getValue("traceName"));
        return props;
    }
    
     
    private Properties getTimerProperties(DefaultModel model){
        Properties props =  new Properties();
        setProp(props, PROPERTY_TIMER_DATESTRING, (String) model.getValue("dateString"));
        setProp(props, PROPERTY_TIMER_PATTERN, (String) model.getValue("pattern"));
        setProp(props, PROPERTY_TIMER_PERIOD, (String) model.getValue("period"));
        setProp(props, PROPERTY_TIMER_NUMBER_OF_OCCURRENCES, (String) model.getValue("occurrence"));
        setProp(props, PROPERTY_TIMER_MESSAGE, (String) model.getValue("message"));
        setProp(props, PROPERTY_TIMER_PATTERN, (String) model.getValue("pattern"));
        return props;
    }
    
    
    
    private Properties getMonitorProperties(DefaultModel model){
        Properties props =  new Properties();
        
        setProp(props, PROPERTY_MONITOR_OBSERVED_OBJ, (String) model.getValue("observedObject"));
        setProp(props, PROPERTY_MONITOR_OBSERVED_ATTRIBUTE, (String) model.getValue("observedAttr"));
        setProp(props, PROPERTY_MONITOR_GRANULARITY_PERIOD, (String) model.getValue("period"));
        
        String monitorType = (String) model.getValue("monitorType");
        setProp(props, PROPERTY_MONITOR_TYPE,  monitorType );
        
        if(PROPERTY_MONITOR_GAUGE.equals(monitorType)){
            setProp(props, PROPERTY_MONITOR_NUMBERTYPE, (String) model.getValue("gaugeNumberType"));
            setProp(props, PROPERTY_MONITOR_DIFFERENCEMODE, (String) model.getValue("gaugeDiff"));
            setProp(props, PROPERTY_MONITOR_HIGH_THRESHOLD, (String) model.getValue("gaugeHighThreshold"));
            setProp(props, PROPERTY_MONITOR_LOW_THRESHOLD, (String) model.getValue("gaugeLowThreshold"));
        }else
        if(PROPERTY_MONITOR_COUNTER.equals(monitorType)){
            setProp(props, PROPERTY_MONITOR_NUMBERTYPE, (String) model.getValue("countNumberType"));
            setProp(props, PROPERTY_MONITOR_DIFFERENCEMODE, (String) model.getValue("countDiff"));
            setProp(props, PROPERTY_MONITOR_INIT_THRESHOLD, (String) model.getValue("initThreshold"));
            setProp(props, PROPERTY_MONITOR_OFFSET, (String) model.getValue("offset"));
            setProp(props, PROPERTY_MONITOR_MODULUS, (String) model.getValue("modulus"));
        }else
        if(PROPERTY_MONITOR_STRING.equals(monitorType)){
            String compare = (String) model.getValue("compare");
            if("notifymatch".equals(compare))
                setProp(props, PROPERTY_MONITOR_STRING_NOTIFY,  PROPERTY_MONITOR_STRING_NOTIFY_MATCH);
            else
                setProp(props, PROPERTY_MONITOR_STRING_NOTIFY,  PROPERTY_MONITOR_STRING_NOTIFY_DIFFER);
            
            setProp(props, PROPERTY_MONITOR_STRING_TO_COMPARE,  (String) model.getValue("strValue"));
        }
        return props;
    }
    
    
            
    public void getCommonAttributesForRules(RequestContext ctx, HandlerContext handlerCtx) {
        
        String ruleObjectName = (String) handlerCtx.getInputValue("ruleObjectName");
        String eventObjectName = (String) handlerCtx.getInputValue("eventObjectName");
        
        handlerCtx.setOutputValue("ruleEnabled",  (String) MBeanUtil.getAttribute( ruleObjectName, "enabled"));
        handlerCtx.setOutputValue("ruleDesc", (String) MBeanUtil.getAttribute( ruleObjectName, "description"));
        String eventType = (String) MBeanUtil.getAttribute( eventObjectName, "type");
        handlerCtx.setOutputValue("eventType",  eventType);
        handlerCtx.setOutputValue("recordEvent", (String) MBeanUtil.getAttribute( eventObjectName, "record-event"));
        handlerCtx.setOutputValue("eventLogLevel",  (String) MBeanUtil.getAttribute( eventObjectName, "level"));
        handlerCtx.setOutputValue("eventDesc", (String) MBeanUtil.getAttribute( eventObjectName, "description"));
        
        ObjectName actionObjectName = getActionObjectName(ruleObjectName);
        if (actionObjectName != null){
            String actionMbeanName = (String) MBeanUtil.getAttribute(actionObjectName, "action-mbean-name");
            if (!Util.isEmpty(actionMbeanName)){
                handlerCtx.setOutputValue("action", actionMbeanName);
            }
        }
            
        AttributeList attrs = (AttributeList) MBeanUtil.invoke(eventObjectName, "getProperties", null, null);
        
        if(EVENT_NOTIFICATION.equals(eventType)){
            setupNotificationProperties(attrs);
        }
        handlerCtx.setOutputValue("eventProperties", attrs);
    }
    
    
    private void setupNotificationProperties(List <Attribute> attrs){
        boolean mbean = false;
        for(Attribute attr : attrs){
            String name = (String) attr.getName();
            String value = (String) attr.getValue();
            if (PROPERTY_NOTIFICATION_SOURCEMBEAN.equals(name)){
                mbean = true;
                break;
            }
        }
        if(mbean){
            attrs.add( new Attribute("sourceRB","predefinedMBean"));
        }else
            attrs.add( new Attribute("sourceRB","userdefinedObjName"));
    }
    
     public void getEventPropertyList(RequestContext ctx, HandlerContext handlerCtx) {
         
         String eventObjectName = (String) handlerCtx.getInputValue("eventObjectName");
         String eventType = (String) MBeanUtil.getAttribute(eventObjectName, "type");
         
         /* We can't use the API because the order of the attributes must be match later on with the value we need to set.
          *
          *
         String rulesObjectName = (String) handlerCtx.getInputValue("rulesObjectName");
         Object[] params = {eventType};
         String[] types={"java.lang.String"};
         List list = (List) MBeanUtil.invoke(rulesObjectName, "getEventProperties", params, types);
         handlerCtx.setOutputValue("propertyNameList", list);
          */
         
         ArrayList list = new ArrayList();
         if (EVENT_LOG.equals(eventType)){
             list.add(PROPERTY_LOG_LEVEL);
         }else
         if (EVENT_LIFECYCLE.equals(eventType)){
             list.add(PROPERTY_LIFECYCLE_NAME);
         }else
         if (EVENT_TRACE.equals(eventType)){
             list.add(PROPERTY_TRACE_NAME);
         } else
         if (EVENT_CLUSTER.equals(eventType)){
             list.add(PROPERTY_CLUSTER_NAME);
             list.add(PROPERTY_CLUSTER_SERVERNAME);
         } else
         if (EVENT_TIMER.equals(eventType)){
             list.add(PROPERTY_TIMER_DATESTRING);
             list.add(PROPERTY_TIMER_PATTERN);
             list.add(PROPERTY_TIMER_PERIOD);
             list.add(PROPERTY_TIMER_NUMBER_OF_OCCURRENCES);
             list.add(PROPERTY_TIMER_MESSAGE);
         }else
         if (EVENT_NOTIFICATION.equals(eventType)){
             list.add("sourceRB");
             list.add(PROPERTY_NOTIFICATION_SOURCEMBEAN);
             list.add(PROPERTY_NOTIFICATION_SOURCE_OBJ_NAME);
             list.add(PROPERTY_NOTIFICATION_TYPE);
         }else
         if (EVENT_MONITOR.equals(eventType)){
    
             list.add(PROPERTY_MONITOR_OBSERVED_OBJ);
             list.add(PROPERTY_MONITOR_OBSERVED_ATTRIBUTE);
             list.add(PROPERTY_MONITOR_GRANULARITY_PERIOD);
             
             String type = (String) MBeanUtil.invoke(eventObjectName, "getPropertyValue",
                                new Object[]{PROPERTY_MONITOR_TYPE},  
                                new String[]{"java.lang.String"});
                                
            if(PROPERTY_MONITOR_COUNTER.equals(type)){
                 list.add(PROPERTY_MONITOR_DIFFERENCEMODE);
                 list.add(PROPERTY_MONITOR_NUMBERTYPE);
                 list.add(PROPERTY_MONITOR_INIT_THRESHOLD);
                 list.add(PROPERTY_MONITOR_OFFSET);
                 list.add(PROPERTY_MONITOR_MODULUS);
            }else
            if (PROPERTY_MONITOR_STRING.equals(type)){
                list.add(PROPERTY_MONITOR_STRING_NOTIFY);
                list.add(PROPERTY_MONITOR_STRING_TO_COMPARE);                
            }else
            if (PROPERTY_MONITOR_GAUGE.equals(type)){
                 list.add(PROPERTY_MONITOR_DIFFERENCEMODE);
                 list.add(PROPERTY_MONITOR_NUMBERTYPE);
                 list.add(PROPERTY_MONITOR_LOW_THRESHOLD);
                 list.add(PROPERTY_MONITOR_HIGH_THRESHOLD);
            }
         }
         handlerCtx.setOutputValue("propertyNameList", list);
     }
    
     
     public void getTranslatedMonitorType(RequestContext ctx, HandlerContext handlerCtx) {
         String eventObjectName = (String) handlerCtx.getInputValue("eventObjectName");
         String type = (String) MBeanUtil.invoke(eventObjectName, "getPropertyValue",
                                new Object[]{PROPERTY_MONITOR_TYPE},  
                                new String[]{"java.lang.String"});
            
         handlerCtx.setOutputValue("mtype", translatedMonitorType(type));
     }
     
     
     private String translatedMonitorType(String type){
         String mtype = null;
         
         if(PROPERTY_MONITOR_COUNTER.equals(type)){
             mtype = Util.getMessage("managementRule.Count");
         }else
         if (PROPERTY_MONITOR_STRING.equals(type)){
             mtype = Util.getMessage("managementRule.String");
         }else
         if (PROPERTY_MONITOR_GAUGE.equals(type)){
             mtype = Util.getMessage("managementRule.Gauge");
         }
         return mtype;
     } 
     
     
     public void changeAction(RequestContext ctx, HandlerContext handlerCtx) {
         
         String ruleObjectName = (String) handlerCtx.getInputValue("ruleObjectName");
         String actionMbeanName = (String) handlerCtx.getInputValue("actionMbeanName");
         ObjectName actionObjectName = getActionObjectName(ruleObjectName);
         
         
         if (Util.isEmpty(actionMbeanName)){
             if (actionObjectName != null)
                MBeanUtil.invoke(ruleObjectName, "removeAction", null, null);
             return;
         }
         
         if (actionObjectName != null){
             String origActionMbeanName = (String) MBeanUtil.getAttribute(actionObjectName, "action-mbean-name");
             if (!actionMbeanName.equals(origActionMbeanName)){
                 MBeanUtil.invoke(ruleObjectName, "removeAction", null, null);
             }else{
                 return;
             }
         }
         AttributeList attrs = new AttributeList();
         attrs.add(new Attribute("action-mbean-name", actionMbeanName));
         Object params[] = {attrs };
         String types[] = {"javax.management.AttributeList" };
         MBeanUtil.invoke(ruleObjectName, "createAction", params, types );
         
     }
    
     //For Save in Editing
     public void setLogEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
         String objectName = (String) handlerCtx.getInputValue("objectName");
         Object[] loggers= (Object[]) handlerCtx.getInputValue("logger");
         String logLevel = (String) handlerCtx.getInputValue("logLevel");
         
         String allLogger = null;
         if (loggers != null) {
	    int len = ((Object[])loggers).length;
	    for (int count=0; count<len; count++) {
		String val = (String) (((Object[])loggers)[count]);
		if ((val == null) || (val.toString().trim().length() == 0)) {
		    continue;
		}
		allLogger = (allLogger == null) ? val : allLogger+ ","+ val;
	    }
	}
         setPropertyWithValue(objectName,PROPERTY_LOG_LOGGERNAME, allLogger );
         setPropertyWithValue(objectName,PROPERTY_LOG_LEVEL, logLevel );
         
     }
     
     
     public void setLifeCycleEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
         String objectName = (String) handlerCtx.getInputValue("objectName");
         String lifeCycleName = (String) handlerCtx.getInputValue("lifeCycleName");
         setPropertyWithValue(objectName,PROPERTY_LIFECYCLE_NAME, lifeCycleName );
     }
     
     
     public void setTraceEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
         String objectName = (String) handlerCtx.getInputValue("objectName");
         String traceName = (String) handlerCtx.getInputValue("traceName");
         setPropertyWithValue(objectName,PROPERTY_TRACE_NAME, traceName );
     }
     
      public void setClusterEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
         String objectName = (String) handlerCtx.getInputValue("objectName");
         String clusterEventName = (String) handlerCtx.getInputValue("clusterEventName");
         String clusterEventServerName = (String) handlerCtx.getInputValue("clusterEventServerName");
         
         setPropertyWithValue(objectName,PROPERTY_CLUSTER_NAME, clusterEventName );
         setPropertyWithValue(objectName,PROPERTY_CLUSTER_SERVERNAME, clusterEventServerName );
     }
      
        
      public void setTimerEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
         String objectName = (String) handlerCtx.getInputValue("objectName");
         
        setPropertyWithValue(objectName,PROPERTY_TIMER_DATESTRING, (String) handlerCtx.getInputValue("dateString") );
        setPropertyWithValue(objectName,PROPERTY_TIMER_PATTERN, (String) handlerCtx.getInputValue("pattern") );
        setPropertyWithValue(objectName,PROPERTY_TIMER_PERIOD, (String) handlerCtx.getInputValue("period") );
        setPropertyWithValue(objectName,PROPERTY_TIMER_NUMBER_OF_OCCURRENCES, (String) handlerCtx.getInputValue("occurrence") );
        setPropertyWithValue(objectName,PROPERTY_TIMER_MESSAGE, (String) handlerCtx.getInputValue("message") );
     }
      
      
     public void setMonitorEventGaugeProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String) handlerCtx.getInputValue("objectName");
        setPropertyWithValue(objectName,PROPERTY_MONITOR_GRANULARITY_PERIOD, (String) handlerCtx.getInputValue("period"));
        setPropertyWithValue(objectName,PROPERTY_MONITOR_NUMBERTYPE, (String) handlerCtx.getInputValue("gaugeNumberType") );
        setPropertyWithValue(objectName,PROPERTY_MONITOR_DIFFERENCEMODE, (String) handlerCtx.getInputValue("gaugeDiff") );
        setPropertyWithValue(objectName,PROPERTY_MONITOR_LOW_THRESHOLD, (String) handlerCtx.getInputValue("gaugeLowThreshold") );
        setPropertyWithValue(objectName,PROPERTY_MONITOR_HIGH_THRESHOLD, (String) handlerCtx.getInputValue("gaugeHighThreshold") );
     }
     
     
     public void setMonitorEventCountProperties(RequestContext ctx, HandlerContext handlerCtx) {
         
        String objectName = (String) handlerCtx.getInputValue("objectName");
        setPropertyWithValue(objectName,PROPERTY_MONITOR_GRANULARITY_PERIOD, (String) handlerCtx.getInputValue("period"));
        setPropertyWithValue(objectName,PROPERTY_MONITOR_NUMBERTYPE, (String) handlerCtx.getInputValue("countNumberType") );
        setPropertyWithValue(objectName,PROPERTY_MONITOR_DIFFERENCEMODE, (String) handlerCtx.getInputValue("countDiff") );
        setPropertyWithValue(objectName,PROPERTY_MONITOR_INIT_THRESHOLD, (String) handlerCtx.getInputValue("initThreshold") );
        setPropertyWithValue(objectName,PROPERTY_MONITOR_OFFSET, (String) handlerCtx.getInputValue("offset") );
        setPropertyWithValue(objectName,PROPERTY_MONITOR_MODULUS, (String) handlerCtx.getInputValue("modulus") );
     }
     
     
     public void setMonitorEventStringProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String) handlerCtx.getInputValue("objectName");
        setPropertyWithValue(objectName,PROPERTY_MONITOR_GRANULARITY_PERIOD, (String) handlerCtx.getInputValue("period"));
        setPropertyWithValue(objectName,PROPERTY_MONITOR_STRING_NOTIFY, (String) handlerCtx.getInputValue("compare") );
        setPropertyWithValue(objectName,PROPERTY_MONITOR_STRING_TO_COMPARE, (String) handlerCtx.getInputValue("strValue") );
     }
     
     public void setNotificationEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String) handlerCtx.getInputValue("objectName");
        String sourceRB = (String) handlerCtx.getInputValue("sourceRB");
        if ("predefinedMBean".equals(sourceRB)){
            setPropertyWithValue(objectName,PROPERTY_NOTIFICATION_SOURCEMBEAN, (String) handlerCtx.getInputValue("sourceMbean") );
        }else{
            setPropertyWithValue(objectName,PROPERTY_NOTIFICATION_SOURCE_OBJ_NAME, (String) handlerCtx.getInputValue("sourceObjectName") );
        }
        setPropertyWithValue(objectName, PROPERTY_NOTIFICATION_TYPE, (String) handlerCtx.getInputValue("notificationType") ); //TODO need to get from Constants 
     }
        
      
      private void setPropertyWithValue(String objectName, String name, String value){
         Object params[] = {new Attribute(name, value)};
         String types[] = {"javax.management.Attribute"};
         String origValue = "";
         try{
             Object pp[] = {name};
             String tt[]= {"java.lang.String"};
             origValue = (String) MBeanUtil.invoke(objectName, "getPropertyValue", pp, tt);
             if (origValue == null) origValue="";
        }catch(Exception ex) {
            //ignore exception thrown when period never specified before.
        }
        if (! (Util.isEmpty(value) && Util.isEmpty(origValue))){
             if (!origValue.equals(value))
                MBeanUtil.invoke(objectName, "setProperty", params, types);
        }
            
     }
      
     public void populateClusterEventName(RequestContext ctx, HandlerContext handlerCtx) {
         populateDropDownEventProperties(handlerCtx,  EVENT_CLUSTER, PROPERTY_CLUSTER_NAME );
     }
     
     
      public void populateClusterEventServerName(RequestContext ctx, HandlerContext handlerCtx) {
           populateDropDownEventProperties(handlerCtx,  EVENT_CLUSTER, PROPERTY_CLUSTER_SERVERNAME );
      }
       
   
     private ObjectName getActionObjectName( String ruleObjectName){
         try {
            ObjectName actionObjectName = (ObjectName) MBeanUtil.invoke(ruleObjectName, "getAction", null, null);
            return actionObjectName;
        }catch(Exception ex){
            //backend will throw a MBeanConfigInstanceNotFoundException if the action element doesn't exist.  action element is optional.
            //just ignore this since action element is optional.
            return null;
        }
     }
     
     
     public void populateMonitorType(RequestContext ctx, HandlerContext handlerCtx) {
         populateDropDownEventProperties(handlerCtx,  EVENT_MONITOR, PROPERTY_MONITOR_TYPE );
     }

     
     public void populateGaugeNumberType(RequestContext ctx, HandlerContext handlerCtx) {
        // the child can be dropdown or radiobutton
        populateDropDownEventProperties(handlerCtx,  EVENT_MONITOR, PROPERTY_MONITOR_NUMBERTYPE );
     }
     
     public void populateNotificationSourceMbean(RequestContext ctx, HandlerContext handlerCtx) {
        // the child can be dropdown or radiobutton
        populateDropDownEventProperties(handlerCtx,  EVENT_NOTIFICATION, PROPERTY_NOTIFICATION_SOURCEMBEAN );
     }
     
     
      private void populateDropDownEventProperties(HandlerContext handlerCtx, String eventType, String propertyName){
          
        // the child can be dropdown or radiobutton
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        String initialValue = (String)handlerCtx.getInputValue("initialValue");
        String rulesObjectName = (String)handlerCtx.getInputValue("rulesObjectName");
        
        Object params[] = { eventType, propertyName };
        String types[] = { "java.lang.String", "java.lang.String" };
        
        List <String> list = (List) MBeanUtil.invoke(rulesObjectName, "getEventPropertyValues", params, types);
        if (list == null)  return;
        
        TreeSet <String>  tset = new TreeSet(list);   //sorting
        
        OptionList optionList = new OptionList();
        
        if (propertyName.equals(PROPERTY_LOG_LOGGERNAME) || propertyName.equals(PROPERTY_CLUSTER_SERVERNAME)){
            optionList.add("*", "*");
        }
        if (propertyName.equals(PROPERTY_NOTIFICATION_SOURCEMBEAN)){
            if(tset.size() < 1)
                optionList.add("  ", "");
        }
        
        for (String  event : tset) {
            if (Util.isEmpty(event))
                continue;
            if (PROPERTY_MONITOR_TYPE.equals(propertyName))
                optionList.add(translatedMonitorType(event), event);
            else
                optionList.add(event, event);
        }
        
        dropDownChild.setOptions(optionList);
        
        if (dropDownChild.getValue() == null && !Util.isEmpty(initialValue)) {
            dropDownChild.setValue(initialValue);
        }
    }
     
}
