/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.servlet;

import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

import java.io.*;
import java.util.*;
import java.net.URL;

import javax.servlet.*;
import javax.servlet.http.*;

import java.io.InputStreamReader;


/**
 *  This class allows us to load help files from classpath.
 */
public class HandleHelpFiles extends HttpServlet {

    public void init(ServletConfig config) throws ServletException {
	super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
	doPost(req, res);
    }


    /**
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
	String pathInfo = req.getPathInfo();
	String servletPath = req.getServletPath();
	
	URL htmlFile = null;
	
	if(pathInfo == null || pathInfo.length() == 0) {
	    //may never come here.
	    pathInfo = "/index.html";
	}
	htmlFile = getClass().getClassLoader().getResource(servletPath.substring(1)+pathInfo);
	
	if(htmlFile == null) {
	    //falling back to the default html file.
	    htmlFile = getClass().getClassLoader().getResource(servletPath.substring(1)+"/notfound.html");
	}
	
	try {
	    ServletOutputStream sout = res.getOutputStream();
	    res.setCharacterEncoding("UTF-8");
	    res.setContentType("text/html");
	    BufferedReader bin = new BufferedReader
                (new InputStreamReader(htmlFile.openStream(), "UTF-8"));
            String line;
	    while ((line=bin.readLine())!=null) {
                sout.println(line);
	    }
            sout.close();
	} catch (IOException ex) {
	    Util.logWARNING("******HandleHelpFiles*******"+ex.getMessage());
	}
    }
}
