/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.servlet;

import java.io.InputStreamReader;
import java.io.IOException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.net.URL;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.management.ObjectName;

import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

public class HandleQuickStartDocs extends HttpServlet {

    public void init(ServletConfig config) throws ServletException {
	super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
	doPost(req, res);
    }


    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
	String pathInfo = req.getPathInfo();
	
	if(pathInfo == null || pathInfo.length() == 0) {
	    //default.
	    pathInfo = "/QuickStart.html";
	}
        File fileIn = null;
        FileInputStream streamIn = null;
        
        try {
            //get requested file
            fileIn = new File(getInstallDir()+pathInfo);
            
            if(!fileIn.exists()) {
            	//falling back to english by default
            	fileIn = new File(getInstallDir()+"/QuickStart.html");
            }
            
            //open input stream
            if(fileIn.canRead())
                streamIn = new FileInputStream(fileIn);
            else {
                res.sendError(400, req.getRequestURI());
                return;
           	
            }
            
        } catch (Exception e)
        {
        	res.sendError(400, req.getRequestURI());
        	return;
        }
        
        //create byte array
        byte[] data = new byte[(int)fileIn.length()];
        if(data != null && (int)fileIn.length() > 0) 
        {
            streamIn.read(data);
            streamIn.close();                   
        } 
        
        if(req.getRequestURI().indexOf(".gif") > 0 || req.getRequestURI().indexOf(".jpg") > 0 || req.getRequestURI().indexOf(".jpeg") > 0 ) {
            //get output stream
            ServletOutputStream imageOut = res.getOutputStream();
            
            if(req.getRequestURI().indexOf(".gif") > 0)
                res.setContentType("image/gif");
            else
                res.setContentType("image/jpeg");
            //write binary data to output stream
            imageOut.write(data);
            imageOut.close(); 
        } else { 
           if(req.getRequestURI().indexOf(".css") > 0) {
                res.setContentType("text/css");
            } else {
               res.setContentType("text/html");
                 
            }
                
            //get handle to the output stream   
            ServletOutputStream textOut = res.getOutputStream();
            textOut.write(data);
            textOut.close();
        }
    }
    
    protected String getInstallDir() throws Exception {
        String dir = "";
        try {
            Object[] params = new Object[]{"${com.sun.aas.installRoot}", "server", new Boolean("true")};
            String[] types = new String[]{"java.lang.String", "java.lang.String", "boolean"};
            Object installDir = MBeanUtil.invoke(
            new ObjectName("com.sun.appserv:type=domain,category=config"), "resolveTokens", params, types);
            if(dir != null)
                dir = installDir.toString();
        } catch (Exception ex) {
            throw ex;
        }
        return getDocsDir(dir);
    }
    
    protected String getDocsDir(String dir){
        return dir+"/docs";
    }
    
}
