/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.tree;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;

import com.sun.enterprise.tools.jsfext.component.ComponentUtil;
import com.sun.enterprise.tools.jsfext.component.factory.basic.TreeAdaptor;
import com.sun.enterprise.tools.jsfext.component.factory.basic.TreeAdaptorBase;
import com.sun.enterprise.tools.jsfext.util.Util;

import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import javax.management.ObjectName;


/**
 *  <p> The <code>MBeanTreeAdaptor</code> implementation must have a
 *	<code>public static MBeanTreeAdaptor getInstance(FacesContext,
 *	LayoutComponent, UIComponent)</code> method in order to get access to
 *	an instance of the <code>MBeanTreeAdaptor</code> instance.</p>
 *
 *  <p>	This class is used by <code>DynamicTreeNodeFactory</code>.</p>
 *
 *  @author Ken Paulsen (ken.paulsen@sun.com)
 */
public class MBeanTreeAdaptor extends TreeAdaptorBase {

    /**
     *	<p> This constructor is not used.</p>
     */
    private MBeanTreeAdaptor() {
    }

    /**
     *	<p> This constructor saves the <code>LayoutComponent</code> descriptor
     *	    and the <code>UIComponent</code> associated with this
     *	    <code>TreeAdaptor</code>.  This constructor is used by the
     *	    getInstance() method.</p>
     */
    protected MBeanTreeAdaptor(LayoutComponent desc, UIComponent parent) {
	super(desc, parent);
    }

    /**
     *	<p> This method provides access to an <code>MBeanTreeAdaptor</code>
     *	    instance.  Each time it is invoked, it returns a new instance.</p>
     */
    public static TreeAdaptor getInstance(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
	return new MBeanTreeAdaptor(desc, parent);
    }

    /**
     *	<p> This method is called shortly after
     *	    {@link #getInstance(FacesContext, LayoutComponent, UIComponent)}.
     *	    It provides a place for post-creation initialization to take
     *	    occur.</p>
     */
    public void init() {
	// Get the FacesContext
	FacesContext ctx = FacesContext.getCurrentInstance();

	// This is the descriptor for this dynamic TreeNode, it contains all
	// information (options) necessary for this Adaptor
	LayoutComponent desc = getLayoutComponent();

	// The parent UIComponent
	UIComponent parent = getParentUIComponent();

	// Get the Object Name
	Object val = desc.getEvaluatedOption(ctx, "objectName", parent);
	if (val == null) {
	    throw new IllegalArgumentException(
		    "'objectName' must be specified!");
	}
        _objectName = (String) val;

	// Get the Method Name
	val = desc.getEvaluatedOption(ctx, "methodName", parent);
	if (val == null) {
	    throw new IllegalArgumentException(
		    "'methodName' must be specified!");
	}
	_methodName = (String) val;

	// Get Parameters
	_paramsArray = null;
	val = desc.getEvaluatedOption(ctx, "parameters", parent);
	if (val != null) {
	    if (val instanceof List) {
		_paramsArray = ((List) val).toArray();
	    } else {
		_paramsArray = new Object[] {val};
	    }
	}

	// Get Parameter Types
	_paramTypesArray = null;
	val = desc.getEvaluatedOption(ctx, "paramTypes", parent);
	if (val != null) {
	    if (val instanceof String) {
		_paramTypesArray = new String[] {(String) val};
	    } else if (val instanceof List) {
		_paramTypesArray = (String [])
		    ((List<String>) val).toArray(new String[0]);
	    } else {
		throw new IllegalArgumentException(
			"'paramTypes' must be a String or a List of types!");
	    }
	}

	// Get the attribute name for the text (optional)
	_nameAtt = (String) desc.getEvaluatedOption(
		ctx, "attributeName", parent);
	if (_nameAtt != null) {
	    _nameAtt = _nameAtt.trim();
	    if (_nameAtt.length() == 0) {
		_nameAtt = null;
	    }
	}

	// Get the method name for the text (optional)
	_nameMethod = (String) desc.getEvaluatedOption(
		ctx, "attrNameMethod", parent);
	if (_nameMethod != null) {
	    _nameMethod = _nameMethod.trim();
	    if (_nameMethod.length() == 0) {
		_nameMethod = null;
	    }
	}

	/*
FIXME:	 See "DynamicTreeNode.java -- The code in getChildObjectNames should be
FIXME:	 broken up between this method and the next (getChildTreeNodeObjects).
FIXME:	 This file should only deal w/ the normal MBean use case.  WebServices
FIXME:	 should be handled via WebServiceTreeAdaptor (to be written).
	*/

	// The following method should set the "key" to the node containing all
	// the children... the children will also have keys which must be
	// retrievable by the next method (getChildTreeNodeObjects)... these
	// "keys" will be used by the rest of the methods in this file for
	// getting information about the TreeNode that should be built.
	setTreeNodeObject(_objectName);
    }

    /**
     *	<p> Returns child <code>TreeNode</code>s for the given
     *	    <code>TreeNode</code> model Object.</p>
     */
    public List getChildTreeNodeObjects(Object nodeObject) {
	if (nodeObject == null) {
	    return null;
	}
	if (nodeObject.toString().equals(_objectName)) {
	    // In this implementation _objectName represents the top-level,
	    // we need to find its children here
	    if (_children != null) {
		return Arrays.asList((Object[])_children);
	    }
            _children = (Object []) MBeanUtil.invoke(
		_objectName, _methodName,
		_paramsArray, _paramTypesArray);

	    // Ok, we go the result, provide an event in case we want to
	    // do some filtering
	    FacesContext ctx = FacesContext.getCurrentInstance();
	    Object retVal = getLayoutComponent().dispatchHandlers(
		    ctx, FilterTreeEvent.EVENT_TYPE,
		    new FilterTreeEvent(getParentUIComponent(), _children));
	    if ((retVal != null) && (retVal instanceof Object [])) {
		// We have a return value, use it instead of the original list
		_children = (Object []) retVal;
	    }
	} else {
	    // Currently multiple levels are not implemented
	    return null;
	}

	return _children != null ? Arrays.asList((Object[])_children):null; 
    }

    /**
     *	<p> This method returns the "options" that should be supplied to the
     *	    factory that creates the <code>TreeNode</code> for the given tree
     *	    node model object.</p>
     *
     *	<p> Some useful options for the standard <code>TreeNode</code>
     *	    component include:<p>
     *
     *	<ul><li>text</li>
     *	    <li>url</li>
     *	    <li>imageURL</li>
     *	    <li>target</li>
     *	    <li>action<li>
     *	    <li>actionListener</li>
     *	    <li>expanded</li></ul>
     *
     *	<p> See Tree / TreeNode component documentation for more details.</p>
     */
    public Map getFactoryOptions(Object nodeObject) {
	if (nodeObject == null) {
	    return null;
	}

	LayoutComponent desc = getLayoutComponent();
	Properties props = new Properties();
	if (nodeObject.toString().equals(_objectName)) {
	    // This case deals with the top node.

	    // NOTE: All supported options must be handled here,
	    //		otherwise they'll be ignored.
	    // NOTE: Options will be evaluated later, do not eval here.
	    setProperty(props, "text", desc.getOption("text"));
	    setProperty(props, "url", desc.getOption("url"));
	    setProperty(props, "imageURL", desc.getOption("imageURL"));
	    setProperty(props, "target", desc.getOption("target"));
	    setProperty(props, "action", desc.getOption("action"));

	    // NOTE: Although actionListener is supported, LH currently
	    //	     implements this to be the ActionListener of the "turner"
	    //	     which is inconsistent with "action".  We should make use
	    //	     of the "Handler" feature which provides a "toggle"
	    //	     CommandEvent.
	    setProperty(props, "actionListener", desc.getOption("actionListener"));
	    setProperty(props, "expanded", desc.getOption("expanded"));
	} else {
	    // This case deals with the children

	    // NOTE: All supported options must be handled here,
	    // otherwise they'll be ignored

// FIXME: There was a check near here (in DynamicTreeNode.updateKids(...) for
// FIXME: isChildValid... figure out how we want to expose an "exludes" list
// FIXME: or filter to make this more generalized.
	    if (nodeObject instanceof ObjectName) {
		if (_nameAtt != null) {
		    setProperty(props, "text",
			(String) MBeanUtil.getAttribute(
				(ObjectName) nodeObject, _nameAtt));
		} else if (_nameMethod != null) {
		    // This is for monitoring MBeans, they don't have a name
		    // attr, but perhaps a getName() method.
		    setProperty(props, "text", (String) MBeanUtil.invoke(
			(ObjectName) nodeObject, _nameMethod, null, null));
		}
		if (!props.containsKey("text")) {
		    // fallback to the object name
		    setProperty(props, "text", nodeObject.toString());
		}
	    } else if (nodeObject instanceof String) {
		setProperty(props, "text", (String) nodeObject);
/*
    FIXME: This is from line #108 - 109 of DynamicTreeNode.java:
    node.setAttribute("webServiceKey", webServiceKeyMap.get(name));
    node.setAttribute("webServiceName", name);
*/
	    } else {
		throw new RuntimeException("'" + nodeObject
			+ "' Illegal type ("
			+ nodeObject.getClass().getName()
			+ ") for tree processing");
	    }

	    // Finish setting the child properties
	    setProperty(props, "url", desc.getOption("childURL"));
	    setProperty(props, "imageURL", desc.getOption("childImageURL"));
	    setProperty(props, "target", desc.getOption("childTarget"));
	    setProperty(props, "action", desc.getOption("childAction"));
// We are using "childActionListener" for the hyperlink, not the TreeNode
//	    setProperty(props, "actionListener", desc.getOption("childActionListener"));
	    setProperty(props, "expanded", desc.getOption("childExpanded"));
	}

	// Return the options
	return props;
    }

    /**
     *	<p> Helper method for setting Properties while avoiding NPE's.</p>
     */
    private void setProperty(Properties props, String key, Object value) {
	if (value != null) {
	    props.put(key, value);
	}
    }

    /**
     *	<p> This method returns the <code>id</code> for the given tree node
     *	    model object.</p>
     */
    public String getId(Object nodeObject) {
	if (nodeObject == null) {
	    return "nullNodeObject";
	}
	if (nodeObject.toString().equals(_objectName)) {
	    // Top level can use the ID of the LayoutComponent
	    return getLayoutComponent().getId(
		FacesContext.getCurrentInstance(), getParentUIComponent());
	}
	return genId(nodeObject.toString());
    }

    /**
     *	<p> This method generates an ID that is safe for JSF for the given
     *	    String.  It does not guarantee that the id is unique, it is the
     *	    responsibility of the caller to pass in a String that will result
     *	    in a UID.  All non-ascii characters will be stripped.</p>
     *
     *	@param	uid	A non-null String.
     */
    private String genId(String uid) {
	char [] chArr = uid.toCharArray();
	int len = chArr.length;
	int newIdx = 0;
	for (int idx=0; idx<len; idx++) {
	    if (Character.isLetter(chArr[idx])) {
		chArr[newIdx++] = chArr[idx];
	    }
	}
	return new String(chArr, 0, newIdx);
    }

    /**
     *	<p> This method returns any facets that should be applied to the
     *	    <code>TreeNode</code> that is created for the given tree node
     *	    model object.  Useful facets for the standard
     *	    <code>TreeNode</code> component are: "content" and "image".</p>
     */
    public Map getFacets(UIComponent comp, Object nodeObject) {
	if (nodeObject.toString().equals(_objectName)) {
	    return null;
	}
	LayoutComponent desc = this.getLayoutComponent();
	Object val = desc.getOption("childActionListener");
	Map map = null;
	if (val != null) {
	    // We have an ActionListener, therefor we need to use a facet
	    Properties props = new Properties();
	    props.put("actionListener", val.toString());
	    setProperty(props, "target", desc.getOption("childTarget"));
	    setProperty(props, "text", comp.getAttributes().get("text"));

	    // Create Hyperlink
	    UIComponent link = ComponentUtil.getChild(
		    (UIComponent) null, "link",
		    "com.sun.enterprise.tools.jsfext.component.factory.basic.HyperlinkFactory",
		    props);

	    // Set href's handlers
	    List handlers = desc.getHandlers("childCommand");
	    if (handlers != null) {
		link.getAttributes().put("command", handlers);
	    }

	    // Create a Facet Map
	    map = new HashMap();
	    map.put("content", link);
	}
	return map;
    }

    /**
     *	<p> Advanced framework feature which provides better handling for
     *	    things such as expanding TreeNodes, beforeEncode, and other
     *	    events.</p>
     *
     *	<p> This method should return a <code>Map</code> of <code>List</code>
     *	    of <code>Handler</code> objects.  Each <code>List</code> in the
     *	    <code>Map</code> should be registered under a key that cooresponds
     *	    to to the "event" in which the <code>Handler</code>s should be
     *	    invoked.</p>
     */
    public Map getHandlersByType(UIComponent comp, Object nodeObject) {
	/* These handlers apply to the TreeNode not the Hyperlink */
	/*
	LayoutComponent lc = this.getLayoutComponent();
	List list = lc.getHandlers("childCommand");
	if (list != null) {
	    Map m = new HashMap();
	    m.put("command", list);
	    return m;
	}
	*/
	return null;
    }

    /**
     *	<p> This method returns the <code>UIComponent</code> factory class
     *	    implementation that should be used to create a
     *	    <code>TreeNode</code> for the given tree node model object.</p>

	This method provides a means use different TreeNodeFactories,
	currently we are using the default which is defined in the superclass,
	if needed we can change this.

    public String getFactoryClass(Object nodeObject) {
	return "com.sun.enterprise.tools.jsfext.component.factory.basic.TreeNodeFactory";
    }
     */

    /**
     *	The MBean object name.
     */
    private String	_methodName	=   null;

    /**
     *	The MBean object name.
     */
    private String	_objectName	=   null;

    /**
     *	The MBean method parameters.
     */
    private Object[]	_paramsArray    =   null;

    /**
     *	The MBean method parameter types.
     */
    private String[]	_paramTypesArray=   null;

    /**
     *	The name of the attribute which describes the TreeNode name.
     */
    private String	_nameAtt	=   null;

    /**
     *	The name of the method which describes the TreeNode name.
     */
    private String	_nameMethod	=   null;

    /**
     *	This sub-nodes of the top-level Node.
     */
    private Object[]	_children	=   null;
}
