/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import java.io.Serializable;

import javax.management.ObjectName;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.util.NonSyncStringBuffer;

import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

public class MonitorTreeNode extends IndexTreeNode implements Serializable {
    
    public MonitorTreeNode(IndexTreeNode parent, String type, String name, IndexTreeModel model) {
	super(parent, type, name, model);
    }
    
    protected void ensureChildren() {
        if (getRefresh() == false) 
            return;
        try {
            updateKids();
        } catch (Exception ex) {
	    if (Util.isLoggableINFO()) {
		Util.logINFO("ERROR in IndexTreeNode.ensureChildren.", ex);
	    }
        }
	setRefresh(false);
    }
    
    private void updateKids() { 
        String objectName = (String)getAttribute("objectName");
        if (objectName == null || objectName.length() == 0)
            throw new RuntimeException(
                "Object name attribute is required for tree node: "+getName());
        
        objectName = replaceTokens(objectName);
        //System.out.println("objectName: "+objectName);
        int i;
        
        // add all the kids to the reserve list, if they are not already on it.
        for (i=0; i<children.size(); i++) {
            if (reserveKids.contains(children.get(i)) == false)
                reserveKids.add(children.get(i));
        }
        // remove all the kids and then add back as necessary
        children.clear();
        
        for (i=0; i<reserveKids.size(); i++) {
            IndexTreeNode node = (IndexTreeNode)reserveKids.get(i);
            Object monitorAttr = node.getAttribute("monitorAttr");
            if (monitorAttr == null) {
                // no attr, just add the node.
                children.add(node);
            }
            else if (monitorAttr instanceof String) {
                String value = (String)MBeanUtil.getAttribute(objectName, (String)monitorAttr);
                if (value != null && value.equalsIgnoreCase("off") == false) {
                    children.add(node);
                }
            } else if (monitorAttr instanceof ArrayList) {
                // if any of the values are turned on, then add the node.
                Iterator it = ((List)monitorAttr).iterator();
                while (it.hasNext()) {
                    String value = (String)MBeanUtil.getAttribute(objectName, (String)it.next());
                    if (value != null && value.equalsIgnoreCase("off") == false) {
                        children.add(node);
                        break;
                    }
                }
            }
        }
    }
    
    protected List reserveKids = new ArrayList();
}
