/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.tree;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ModelManager;
import com.iplanet.jato.model.TreeModelBase;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ValidationException;
import com.iplanet.jato.util.StringTokenizer2;

import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;

import java.util.List;
import java.util.ListIterator;
import java.lang.Thread;
import java.io.InputStream;
import java.io.Serializable;
import javax.servlet.*;


public class TreeModelBaseImpl extends TreeModelBase implements IndexTreeModel, Serializable {
    
    public TreeModelBaseImpl(String treeFileName, String stateDataName) {
	super();
        this.treeFileName = treeFileName;
        this.stateDataName = stateDataName;
    }
    
    public String getStateDataName() {
        return stateDataName;
    }
    
    public String getName() {
	return name;
    }
    
    public void setName(String value) {
	name=value;
    }
    
    public void root() throws ModelControlException {
        if (root == null) {
            throw new RuntimeException("The root node is null!!!");
        }
	setCurrentNode(root);
	setNodeLevel(ROOT_NODE_LEVEL);
	setIterationComplete(false);
    }
    
    public String getNodeName() throws ModelControlException {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node!=null)
	    return node.getName();
	else
	    return null;
    }
    
    public String getNodeType()	throws ModelControlException {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node!=null)
	    return node.getType();
	else
	    return null;
    }
    
    public IndexTreeNode getNode(String nodePath) throws NodeNotFoundException {
	if (Util.isLoggableFINEST()) {
	    Util.logFINEST("IndexTreeModelImpl.getNode : " + nodePath);
	}

	String[] nodeIDs=StringTokenizer2.tokenize(nodePath,".");
	IndexTreeNode node = getRoot();
	for (int i = 1; i < nodeIDs.length; i++) {
	    for (int j=0; j < node.getChildren().size(); j++) {
		IndexTreeNode child=(IndexTreeNode)node.getChildren().get(j);
		if (String.valueOf(child.getID()).equals(nodeIDs[i])) {
		    node = child;
		    break;
		}
	    }
	}
	// Sanity check
	if (!node.getPath().equals(nodePath)) {
	    throw new NodeNotFoundException("Incorrect node (" + node.getPath() + " != "+nodePath+")");
	}
	return node;
    }
    
    public IndexTreeNode getNodeByName(String nodeNamePath) {
	String[] nodeIDs=StringTokenizer2.tokenize(nodeNamePath,".");
	IndexTreeNode node = getRoot();
	for (int i = 1; i < nodeIDs.length; i++) {
	    for (int j=0; j < node.getChildren().size(); j++) {
		IndexTreeNode child=(IndexTreeNode)node.getChildren().get(j);
		if (String.valueOf(child.getName()).equals(nodeIDs[i])) {
		    node = child;
		    break;
		}
	    }
	}
	// Sanity check
	if (!node.getNamePath().equals(nodeNamePath)) {
	    throw new NodeNotFoundException("Incorrect node (" +
		node.getNamePath() + " != "+nodeNamePath+")");
	}
	return node;
    }

    public IndexTreeNode getNodeByUniqueID(String id, String childName, IndexTreeNode node) {
        if (node == null)
            node = getRoot();
        String uniqueID = node.getUniqueID();
        //System.out.print("UNIQUE-ID: "+id+"  "+uniqueID+"  "+node.getName());
        if (uniqueID == null) {
            // stop looking.
            return null;
        }
        List children = node.getChildren();
        if (uniqueID != null && uniqueID.equals(id)) {
            if (childName != null) {
                IndexTreeNode childNode = node.getChild(childName);
                if (childNode != null)
                    return childNode;
            } else {
                return node;
            }
        }
        // keep looking; next look at the kids.
        for (int i=0; i < children.size(); i++) {
            IndexTreeNode child = (IndexTreeNode)children.get(i);
            IndexTreeNode childNode = getNodeByUniqueID(id, childName, child);
            if (childNode != null) {
                return childNode;
            }
        }
	return null;
    }
    
    public void beforeRoot() throws ModelControlException {
	setCurrentNode((Object)null);
	setNodeLevel(UNDEFINED_NODE_LEVEL);
	setIterationComplete(false);
    }
    
    public Object getCurrentNode() {
	return super.getCurrentNode();
    }
    
    public void setCurrentNode(String nodeID) throws ModelControlException, Exception {
	setCurrentNode(getNode(nodeID));
    }
    
    public void setCurrentNode(IndexTreeNode node) {
        super.setCurrentNode(node);
    }
    
    public String getNodeID() {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node!=null)
	    return node.getPath();
	else
	    return null;
    }
    
    public String getNodeHID() {
	// returns the highligh ID for the current node.
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node != null)
	    return node.getHighlightID();
	else
	    return "0";
    }
    
    public String getIconName(boolean expanded) {
	// returns the icon file name for the current node.
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node != null)
	    return node.getIconName(expanded);
	else
	    return "props.gif";
    }
    
    public boolean isParentNode() {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node!=null)
	    return node.getChildren().size()>0;
	else
	    return false;
    }
    
    public boolean isChildNode() {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node!=null)
	    return node.getParent()!=null;
	else
	    return false;
    }
    
    public boolean firstChild()	throws ModelControlException {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node!=null && isParentNode()) {
	    setCurrentNode(node.getChildren().get(0));
	    incrementNodeLevel();
	    return true;
	}
	else {
	    return false;
	}
    }
    
    public boolean parent() throws ModelControlException {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node!=null && isChildNode()) {
	    setCurrentNode(node.getParent());
	    decrementNodeLevel();
	    return true;
	}
	else {
	    return false;
	}
    }
    
    public boolean nextSibling() throws ModelControlException {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node!=null) {
	    IndexTreeNode nextNode=node.getNextSibling();
	    if (nextNode!=null) {
		setCurrentNode(node.getNextSibling());
		return true;
	    }
	    else
		return false;
	}
	else {
	    return false;
	}
    }
    
    public Object getValue(String name) {
	Object[] values=getValues(name);
	if (values==null || values.length==0)
	    return null;
	else
	    return values[0];
    }
    
    public void setValue(String name, Object value)
        throws ValidationException {
	setValues(name,new Object[] {value});
    }
    
    public Object[] getValues(String name) {
        if (getCurrentNode()!=null) {
            if (name.equals("name")) {
                return new Object[] {
                    ((IndexTreeNode)getCurrentNode()).getName()};
            } else {
                
                return new Object[] {
                    ((IndexTreeNode)getCurrentNode()).getAttribute(name)};
            }
        }
        else
            return null;
        
    }
    
    public void setValues(String name, Object[] values) throws ValidationException {
	if (getCurrentNode() != null)
	    ((IndexTreeNode)getCurrentNode()).setAttribute(name,values);
    }
    
    
    protected void createIndexData() {
	try {
            // try loading from the classpath with the call loader. This is cached.
            InputStream inStream = getClass().getClassLoader().getResourceAsStream(treeFileName);
            if (inStream == null) {
                // try getting the file from the context root. This is not cached.
		inStream = RequestManager.getRequestContext().getServletContext().
		    getResourceAsStream(treeFileName);
	    }

            TreeReader reader = new TreeReader(inStream, 
                ViewDescriptorManager.getInstance().getDTDURLBase());
	    reader.populate(this); // this call will set the root node
            root();
	} catch (Exception ex) {
            if (Util.isLoggableINFO()) {
                Util.logINFO("ERROR IN READING TREE FILE: "+treeFileName+"  "+ex.getMessage());
                ex.printStackTrace();
            }
	}
    }
    
    
    public int getNextNodeID() {
	return nodeCount++;
    }
    
    public boolean isInitialExpand() {
	boolean b = initialExpand;
	initialExpand = false;
	return b;
    }
    
    public String getType(String string) {
	IndexTreeNode node=(IndexTreeNode)getCurrentNode();
	if (node != null)
	    return node.getType();
	else
            return ROOT;
    }
    
    public IndexTreeNode getRoot() {
	return root;
    }
        
    public void setRoot(IndexTreeNode node) {
	root = node;
    }
        
    private String treeFileName;
    private String stateDataName;
    private boolean initialExpand = true;
    private String name;
    private int nodeCount = 0;
    private IndexTreeNode root = null; // tree root
}
