/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AMXUtil.java
 *
 * Created on April 13, 2005, 11:43 AM
 */

package com.sun.enterprise.tools.admingui.util;

import java.util.*;

import javax.management.remote.JMXConnector;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.UploadDownloadMgr;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.j2ee.J2EEDomain;
import com.sun.appserv.management.monitor.MonitoringRoot;

public class AMXUtil {

    private static ProxyFactory amxProxyFactory = null;
    private static DomainRoot domainRoot = null;
    private static DomainConfig domainConfig = null;
    private static J2EEDomain j2eeDomain = null;
    private static MonitoringRoot monitoringRoot = null;
    private static QueryMgr queryMgr = null;
    private static UploadDownloadMgr uploadDownloadMgr = null;

    private AMXUtil() {} //dummy constructor, all static methods.
    
    public static DomainConfig getDomainConfig() {
        return domainConfig == null ? getDomainRoot().getDomainConfig() : domainConfig;
    }
    
    public static J2EEDomain getJ2EEDomain() {
        return j2eeDomain == null ? getDomainRoot().getJ2EEDomain() : j2eeDomain;
    }
    
    public static MonitoringRoot getMonitoringRoot() {
        return monitoringRoot ==  null ? getDomainRoot().getMonitoringRoot() : monitoringRoot;
    }
   
    public static DomainRoot getDomainRoot() {
        return domainRoot == null ? getAMXProxyFactory().getDomainRoot() : domainRoot;
    }
    
    public static QueryMgr getQueryMgr() {
        return queryMgr == null ? getDomainRoot().getQueryMgr() : queryMgr;
    }
    
    public static UploadDownloadMgr getUploadDownloadMgr() {
        return uploadDownloadMgr == null ? getDomainRoot().getUploadDownloadMgr() : uploadDownloadMgr;
    }
   
    public static ProxyFactory getAMXProxyFactory() {
        return amxProxyFactory == null ? 
        ProxyFactory.getInstance(MBeanUtil.getMBeanServer()) : amxProxyFactory;
    }

}
