/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MBeanUtil.java
 *
 * Created on April 1, 2003, 11:48 AM
 */

package com.sun.enterprise.tools.admingui.util;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.HashMap;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.config.MBeanConfigInstanceNotFoundException;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

public class MBeanUtil {
    
    private static MBeanServerConnection remoteConnection = null;
    
    // FIXME: this needs to be dynamic.
    //private static final boolean localConnection = true;
    
    public static Object invoke(String objectName, String operationName, Object[] params, String[] signature) {
	try {
	    return invoke(
		new ObjectName(objectName), operationName, params, signature);
	} catch (Exception ex) {
	    if (Util.isLoggableFINE()) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                buf.append(ex.getMessage());
                buf.append("MBUtil.invoke failed:\n");
                buf.append("    OBJECT NAME: "+objectName+"\n");
                buf.append("    OPERATION NAME: "+operationName+"\n");
                Util.logFINE(buf.toString());
            }
	    throw new FrameworkException(ex);
	}
    }
    
    public static AttributeList getAttributes(String objectName, String[] attributeNames) {
	try {
	    return getMBeanServer().getAttributes(new ObjectName(objectName), attributeNames);
	} catch (Exception ex) {
	    throw new FrameworkException(ex);
	}
    }
    
    public static Object getAttribute(ObjectName objectName, String attributeName) {
	try {
	    return getMBeanServer().getAttribute(objectName, attributeName);
	} catch (Exception ex) {
	    if (Util.isLoggableFINE()) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                buf.append(ex.getMessage());
                buf.append("Attribute not found on the given Object:\n");
                buf.append("    OBJECT NAME: "+objectName+"\n");
                buf.append("    ATTRIBUTE NAME: "+attributeName+"\n");
                Util.logFINE(buf.toString());
            }
	    throw new FrameworkException(ex);
	}
    }
    
    public static Object getAttribute(String objectName, String attributeName) {
	try {
	    return getMBeanServer().getAttribute(new ObjectName(objectName), attributeName);
	} catch (Exception ex) {
	    if (Util.isLoggableFINE()) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                buf.append(ex.getMessage());
                buf.append("Attribute not found on the given Object:\n");
                buf.append("    OBJECT NAME: "+objectName+"\n");
                buf.append("    ATTRIBUTE NAME: "+attributeName+"\n");
                Util.logFINE(buf.toString());
            }
	    throw new FrameworkException(ex);
	}
    }
    
    public static void setAttribute(String objectName, Attribute attributeName) {
	try {
	    setAttribute(new ObjectName(objectName), attributeName);
	} catch (Exception ex) {
	    throw new FrameworkException(ex);
	}
    }
    
    public static void setAttribute(ObjectName objectName, Attribute attributeName) {
	try {
	    getMBeanServer().setAttribute(objectName, attributeName);
	} catch (Exception ex) {
	    throw new FrameworkException(ex);
	}
    }
        
    public static AttributeList setAttributes(String objectName, AttributeList attributes) {
	try {
	    return getMBeanServer().setAttributes(new ObjectName(objectName), attributes);
	} catch (Exception ex) {
	    throw new FrameworkException(ex);
	}
    }
    
    public static Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) {
	if (Util.isLoggableFINE()) {
	    // Log some trace info
	    NonSyncStringBuffer buf = new NonSyncStringBuffer();
	    buf.append("***** Calling MBean Server *****\n");
	    buf.append("objectName = "+objectName+"\n");
	    buf.append("operationName = "+operationName+"\n");
	    if (params != null) {
		for (int i = 0; i < params.length; i++) {
		    buf.append("params["+i+"] = "+params[i]);
		}
	    }
	    if (signature  != null) {
		for (int i = 0; i < signature.length; i++) {
		    buf.append("types["+i+"] = "+signature[i]);
		}
	    }
	    buf.append("params = "+params);
	    buf.append("signature = "+signature);
	    Util.logFINE(buf.toString());
	}

	try {
            return getMBeanServer().invoke(objectName, operationName, params, signature);
        } catch (Exception ex) {
            // this exception is being handled in a special way - this
            // means that the backend could not find a particular mbean.
            if (ex.getCause() instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw new FrameworkException(ex);
        }
    }
    
    
    public static boolean isValidMBean(String objectName) {
        boolean valid = false;
        try {
            Set beans = getMBeanServer().queryMBeans(new ObjectName(objectName), null);
            if (beans.size() > 0)
                valid = true;
        } catch (Exception ex) {
            // ignore
        }
        return valid;
    }
    /*
    private static Map initEnvironment() {
        final Map env = new HashMap();
        final String PKGS = "com.sun.enterprise.admin.jmx.remote.protocol";

        env.put(JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES, PKGS);
        // FIXME: these values shouldn't be hard coded.
        env.put(DefaultConfiguration.ADMIN_USER_ENV_PROPERTY_NAME, "admin");
        env.put(DefaultConfiguration.ADMIN_PASSWORD_ENV_PROPERTY_NAME, "password");
        env.put(DefaultConfiguration.HTTP_AUTH_PROPERTY_NAME, 
                DefaultConfiguration.DEFAULT_HTTP_AUTH_SCHEME);
        return ( env );
    }
    
    private static MBeanServerConnection getRemoteConnection( String host, int port ) {
        MBeanServerConnection mbeanServer = null;
        try {
            JMXServiceURL url = 
                new JMXServiceURL("service:jmx:s1ashttp://" + host + ":" + port );

            JMXConnector conn = JMXConnectorFactory.connect(url, initEnvironment());
            mbeanServer = conn.getMBeanServerConnection();

        } catch (Exception ex) {
            System.out.println("Remote Connect Failed!!!");
            System.out.println(ex.getMessage());
            throw new RuntimeException(ex);
        }
        return mbeanServer;
    }
    */
    public static MBeanServerConnection getMBeanServer() {
//        if (localConnection) {
            return MBeanServerFactory.getMBeanServer();
//        } else {
//            // FIXME: should not hard code host and port number.
//            if (remoteConnection == null)
//                remoteConnection = getRemoteConnection( "localhost", 2906 );
//           return remoteConnection;
//        }
    }
    
    /* if  types = null and params !=null, make all types Strings. Otherwise
     just return an array from arraylist
     */
    public static Object[] getParamsAndTypes(ArrayList paramsList, ArrayList typesList) {
        String[] types = null;
        Object[] params = null;
        
        if (paramsList == null)
            return new Object[]{null, null};
        
        if (typesList == null) {
            types = new String[paramsList.size()];
            for (int i = 0; i < types.length; i++) {
                types[i] = "java.lang.String";
            }
            if (paramsList != null) {
                params = paramsList.toArray();
            }
            return new Object[] {params, types};
        }
//        for (int i = 0; i < typesList.size(); i++) {
//            System.out.println(typesList.get(i));
//        }
//        for (int i = 0; i < paramsList.size(); i++) {
//            System.out.println(paramsList.get(i));
//        }
        for (int i = 0; i < typesList.size(); i++) {
            Object type = typesList.get(i);
            Object param = paramsList.get(i);

            if (type instanceof ArrayList) {
                ArrayList typeArrayList = (ArrayList)type;
                String[] typesArray = (String[])typeArrayList.toArray(new String[typeArrayList.size()]);
                typesList.remove(i);
                for (int j = 0; j < typesArray.length; j++) {
                    typesList.add(i+j, typesArray[j]);
                }
                if (param != null) {
                    ArrayList paramArrayList = (ArrayList)param;
                    Object[] paramsArray = paramArrayList.toArray();
                    paramsList.remove(i);
                    for (int j = 0; j < paramsArray.length; j++) {
                        paramsList.add(i+j, paramsArray[j]);
                    }
                }
            }
        }
        //System.out.println("got paramsAndTypes");
        types = (String[])typesList.toArray(new String[typesList.size()]);
        params = paramsList.toArray();
        for(int i = 0; i < types.length; i++) {
            if(types[i].equals("boolean") || types[i].equals("java.lang.Boolean")) {
                params[i] =  new Boolean(params[i].toString());
            }
            else if(types[i].equals("java.lang.Integer")) {
                params[i] = new Integer(params[i].toString());
            }
        }
        return new Object[] {params, types};
    }
    
    public static Object[] getParams(ArrayList params, String[] types) {
        if (params == null)
            return null;
        
        if (types == null)
            return null;
        
        return params.toArray();
    }
    
    
    public static void main(String _args[]) {
        ArrayList typesList = new ArrayList();
        ArrayList paramsList = new ArrayList();
        typesList.add("java.lang.String");
        paramsList.add(null);
        Object[] paramArray = null;
        String[] typesArray = null;
        Object[] paramsAndTypes = getParamsAndTypes(paramsList, typesList);
        System.out.println(paramsAndTypes[0]);
    }
}
