/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 */
package com.sun.enterprise.tools.jsfext.component;


/**
 *  <p>	This <code>UIComponent</code> exists to facilitate LavaChannel
 *	requests.  Since these requests send information via the
 *	XMLHttpRequest Object, a standard href or form submit will not work.
 *	Further it is cumbersome to override the JavaScript in the available
 *	set of components to expect the developer to do this for each
 *	request.</p>
 *
 *  @author Ken Paulsen (ken.paulsen@sun.com)
 */
public class LavaChannelHref extends TemplateComponentBase {
    /**
     *	<p> Constructor for <code>LavaChannelHref</code>.</p>
     */
    public LavaChannelHref() {
	super();
	setRendererType("com.sun.enterprise.tools.jsfext.LavaChannelHref");
	setLayoutDefinitionKey(LAYOUT_KEY);
    }

    /**
     *	<p> Return the family for this component.</p>
     */
    public String getFamily() {
	return "com.sun.enterprise.tools.jsfext.LavaChannelHref";
    }

    /**
     *	<p> This is the location of the XML file that declares the layout for
     *	    the LavaChannelHref. (lava/lavaChannelHref.xml)</p>
     */
    public static final String	LAYOUT_KEY  =	"lava/lavaChannelHref.xml";
}
