/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.jsfext.component.factory.basic;

import com.sun.enterprise.tools.jsfext.component.factory.ComponentFactoryBase;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;

import com.sun.web.ui.component.ImageComponent;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;


/**
 *  <p>	This factory is responsible for creating a <code>ImageComponent</code>
 *	UIComponent.</p>
 *
 *  @author Rick Ratta
 *  @author Ken Paulsen	(ken.paulsen@sun.com)
 */
public class ImageComponentFactory extends ComponentFactoryBase {

    /**
     *	<p> This is the factory method responsible for creating the
     *	    <code>ImageComponent</code> UIComponent.</p>
     *
     *	@param	context	    The FacesContext
     *
     *	@param	descriptor  The {@link LayoutComponent} descriptor that is
     *			    associated with the requested
     *			    <code>ImageComponent</code>.
     *
     *	@param	parent	    The parent UIComponent
     *
     *	@return	The newly created <code>ImageComponent</code>.
     */
    public UIComponent create(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
	// Create the UIComponent
	ImageComponent image = new ImageComponent();

	// This needs to be done here (before setOptions) so that $...{...}
	// expressions can be resolved...
	if (parent != null) {
	    addChild(context, descriptor, parent, image);
	}

	// Set all the attributes / properties (allow these to override theme)
	setOptions(context, descriptor, image);

	// Return the value
	return image;
    }
}
