/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.sun.web.ui.taglib.html.CCTextFieldTag;
import com.sun.web.ui.taglib.html.CCTextAreaTag;

import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;


/**
 *
 */
public class ViewDescriptorHandlers {

    /**
     *	This method obtains the hierachy from the top-most ViewDescriptor to
     *	the inner-most ViewDescriptor contains this mapping.  It stores the
     *	names of the ViewDescriptors in the path from the top-most to the
     *	inner-most as a List of Strings and returns this List.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getHierarchy(RequestContext reqCtx, HandlerContext handlerCtx) {
	// Get the inner-most containing ViewDescriptor
	ViewDescriptor topViewDesc = handlerCtx.getViewDescriptor();

	// Use a stack to flip the names
	Stack nameStack = new Stack();

	// Add names to the stack until we run out of ViewDescriptors
	do {
	    nameStack.push(topViewDesc.getName());
	    topViewDesc = topViewDesc.getParent();
	} while (topViewDesc != null);


	// Add the names to path
	List path = new ArrayList();
	while (!nameStack.empty()) {
	    path.add(nameStack.pop());
	}

	// Return path List
	handlerCtx.setOutputValue(VALUE, path);
    }


    /**
     *	This mapping obtains a value of a parameter within a ViewDescriptor.
     *	You must specify the ViewDescriptor by name.  It will search the top-
     *	level ViewDescriptors for the given name.  If you wish to use a child
     *	descriptor of that ViewDescriptor, you may specify as many child
     *	descritpor names as well.  These names (top-level + child names) are
     *	specified by the parameter: 'ViewDescriptorName' (this parameter may
     *	be a List).  You must also specify the name of the parameter(s) to
     *	obtain with parameter: 'ParameterName'.  If you specify more than one
     *	value for 'parameterName', then each parameter of the ViewDescriptor
     *	that you specified will be added to a List which will be returned.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getViewDescriptorParameter(RequestContext reqCtx, HandlerContext handlerCtx) {
	// Get the Name of the ViewDescriptor to obtain a parameter value
	// Get the Parameter name to obtain
	Object paramName = handlerCtx.getInputValue(PARAMETER_NAME);
	if (paramName == null) {
	    throw new IllegalArgumentException(
		"No 'Parameter Name' Specified!");
	}

	ViewDescriptor viewDesc = null;
	Object vdName = handlerCtx.getInputValue(VIEW_DESCRIPTOR_NAME);
	if (vdName == null) {
	    // Use the current ViewDescriptor
	    viewDesc = handlerCtx.getViewDescriptor();
	} else {
	    // Get the ViewDescriptorManager
	    ViewDescriptorManager mgr = ViewDescriptorManager.getInstance();

	    // Get the ViewDescriptor using the VIEW_DESCRIPTOR_NAME
	    if (vdName instanceof List) {
		// Iterate through the keys to find the child ViewDescriptor
		Iterator it = ((List)vdName).iterator();
		String key = it.next().toString();
		viewDesc = mgr.getViewDescriptor(key);
		if (viewDesc == null) {
		    throw new IllegalArgumentException(
			"Top-level ViewDescriptor '"+key+"' not found!");
		}
		while (it.hasNext()) {
		    key = it.next().toString();
		    viewDesc = viewDesc.getChildDescriptor(key);
		    if (viewDesc == null) {
			throw new IllegalArgumentException(
			    "Child ViewDescriptor '"+key+"' not found!");
		    }
		}
	    } else {
		// Obtain the top-level ViewDescriptor directly
		viewDesc = mgr.getViewDescriptor(vdName.toString());
		if (viewDesc == null) {
		    throw new IllegalArgumentException(
			"Top-level ViewDescriptor '"+vdName.toString()+
			"' not found!");
		}
	    }
	}

	// if a list of parameters is required, get each parameter's value
	Object value = null;
	if (paramName instanceof List) {
	    List paramList = (List)paramName;
	    ArrayList paramValueList = new ArrayList();
	    for (int i = 0; i < paramList.size(); i++) {
		paramValueList.add(viewDesc.getParameter((String)paramList.get(i)));
	    }
	    value = paramValueList;
	} else {
	    value = viewDesc.getParameter(paramName.toString());
	}

	// Set the output value
	handlerCtx.setOutputValue(VALUE, value);
    }

//    private String addHtmlProp(String tag, String addText) {
//        int i = tag.indexOf(' ');
//        if (i<0)
//            return tag;
//        return tag.substring(0,i) + " " + addText + tag.substring(i,tag.length());
//    }
//    private String removeHtmlProp(String tag, String prop) {
//        int i = tag.indexOf(prop);
//        if (i<0) return tag;
//        int j = tag.indexOf('\"', i+2+prop.length());
//        if (j<0) return tag;
//        return tag.substring(0,i) + tag.substring(j+2, tag.length());
//    }
//    
//    private String extractHtmlProp(String tag, String prop) {
//         int i = tag.indexOf(prop);
//         if (i<0) return "";
//         int j = tag.indexOf('\"', i+2+prop.length());
//         if (j<0) return "";
//         return tag.substring(i+2+prop.length(), j);
//    }
//    
    // expertimental code to adjust the size of text boxes.
//    public String endFixTextDisplay(RequestContext ctx, HandlerContext handlerCtx) {
//        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
//        String html = ev.getContent();
//
//        if ((ev.getSource() instanceof CCTextFieldTag) == false) 
//            return html;
//                
//        String value = extractHtmlProp(html, "value");
//        if (value == null || value.length() == 0)
//            return html;
//        
//        value = value.trim();
//        
//        String sizeStr = extractHtmlProp(html, "size");
//        if (sizeStr == null || sizeStr.length()== 0)
//            return html;
//        int currentSize = 0;
//        try {
//            currentSize = Integer.parseInt(sizeStr);
//        } catch (Exception ex) {
//            return html;
//        }
//        int size = ((value.length() / 8) + 1) * 10;
//        if (size > 100) size = 100;
//        if (currentSize >= size)
//            return html;
//        html = removeHtmlProp(html, "size");
//        html = addHtmlProp(html, ("size="+size));
//        System.out.println(">>>>>>> current/new size: "+currentSize+"  "+size);
//        
//        return html;
//   }

    public void beginFixTextDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        Object tag = handlerCtx.getEvent().getSource();
        if (tag instanceof CCTextFieldTag) {
            ((CCTextFieldTag)tag).setLocalizeDisplayFieldValue("false");
        }
        else if (tag instanceof CCTextAreaTag) {
            ((CCTextAreaTag)tag).setLocalizeDisplayFieldValue("false");
        }
    }
    
    public static final String VIEW_DESCRIPTOR_NAME	= "ViewDescriptorName";
    public static final String PARAMETER_NAME		= "ParameterName";
    public static final String VALUE			= "value";
}
