/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.model.*;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;

import com.sun.enterprise.tools.guiframework.exception.ChildNotRegisteredException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import com.sun.web.ui.model.CCAddRemoveModelInterface;
import com.sun.web.ui.view.addremove.CCAddRemove;
import javax.servlet.http.*;

public class DescriptorCCAddRemove extends CCAddRemove implements DescriptorContainerView {

    /**
     *	Constructor
     */
    public DescriptorCCAddRemove(RequestContext ctx, ContainerView container, 
            String pageName, ViewDescriptor desc, CCAddRemoveModelInterface model) 
    {
	super(container, model, pageName);
        // This is not necessary, but good practice.
        setDefaultModel((Model)model);
	setRequestContext(ctx);
	setViewDescriptor(desc);
	registerViewDescriptorChildren();
    }

    /**
     *	This method retrieves this View ViewDescriptor.
     *
     *	@return This View's ViewDescriptor.
     */
    public ViewDescriptor getViewDescriptor() {
	return _viewDesc;
    }

    /**
     *	This method sets the ViewDescriptor for this View.
     */
    protected void setViewDescriptor(ViewDescriptor desc) {
	_viewDesc = desc;
    }

    /**
     *	This method registerd the Descriptor children.
     */
    public void registerViewDescriptorChildren() {
	DescriptorViewHelper.registerViewDescriptorChildren(getViewDescriptor(), this);
    }

    /**
     *	This method is defined in ContainerView, but it is important to
     *	to override this.
     *
     *	This method should delegate to the helper createChild method to use the
     *	descriptor information
     */
    public View createChild(String name) {
    	// Try to create the Child via a child descriptor
	View child = null;
	try {
	    child = DescriptorViewHelper.createChild(this, name);
	} catch (ChildNotRegisteredException ex) {
	    // Some children have built-in support via the super class
	    child = super.createChild(name);
	}

	// return the child
	return child;
    }

    /**
     *
     */
    public RequestContext getRequestContext() {
	return _reqCtx;
    }

    /**
     *
     */
    public void setRequestContext(RequestContext context) {
	_reqCtx = context;
    }

    public void forwardTo(RequestContext requestContext) throws NavigationException {
	getParentViewBean().forwardTo(requestContext);
    }

    ////////////////////////////////////////////////////////////
    //                    Event Methods                       //
    ////////////////////////////////////////////////////////////

    /**
     *	This method dispatches BeginDisplay events to each registered
     *	BeginDisplay event handler according the the ViewDescriptor.
     *	This method is defined in ContainerView, but it is important to
     *	to override this.
     *
     *	@param event	The DisplayEvent, created internally by JATO
     */
    public void beginDisplay(DisplayEvent event) throws ModelControlException {
	DescriptorViewHelper.beginDisplay(this, event);
	super.beginDisplay(event);
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) throws ModelControlException {
    	return DescriptorViewHelper.beginChildDisplay(this, event);
    }

    public String endChildDisplay(ChildContentDisplayEvent event) throws ModelControlException {
	return DescriptorViewHelper.endChildDisplay(this, event);
    }

    public void endDisplay(DisplayEvent event) {
	DescriptorViewHelper.endDisplay(this, event);
	super.endDisplay(event);
    }

    private RequestContext _reqCtx = null;
    private ViewDescriptor _viewDesc = null;
}
