/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.command.Command;
import com.iplanet.jato.command.CommandEvent;
import com.iplanet.jato.command.CommandException;
import com.iplanet.jato.command.CommandDescriptor;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelFieldBinding;
import com.iplanet.jato.model.ModelReference;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.CommandField;
import com.iplanet.jato.view.CommandFieldBase;
import com.iplanet.jato.view.CommandFieldDescriptor;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;

import com.sun.web.ui.model.wizard.WizardEvent;

import com.sun.enterprise.tools.guiframework.event.descriptors.EventDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.exception.ChildNotRegisteredException;
import com.sun.enterprise.tools.guiframework.exception.FrameworkError;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.DisplayFieldDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.FakeContainerDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.AfterCreateEvent;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.guiframework.util.Util;
import com.sun.enterprise.tools.guiframework.util.LogUtil;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import javax.servlet.ServletContext;


/**
 *  This class contains static utility methods for DescriptorView's.
 */
public class DescriptorViewHelper {

    /**
     *	This method exists to ease creating a new DescriptorContainerView
     *	implementation.
     */
    public static void registerViewDescriptorChildren(ViewDescriptor viewDesc, ContainerViewBase container) {
	try {
	    viewDesc.registerChildren(container);
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, viewDesc, container);
	}
    }


    /**
     *
     */
    public static View addCommandDescriptor(ContainerView container, View child, ViewDescriptor desc) {
	// Set the CommandDescriptor (so that the default:
	// handle<command-name>Request() method is not looked for)
	if (!(child instanceof CommandField)) {
	    return child;
	}
	if (desc == null) {
	    if (LogUtil.isLoggable(LogUtil.INFO)) {
		LogUtil.log(LogUtil.INFO, "framework.addCommandDescriptor",
		    child.getParent().getName()+"."+child.getName());
	    }
	    return child;
	}

	// Find a "Command" container
	while (container != null) {
	    if (container instanceof Command) {
		break;
	    }
	    container = (ContainerView)container.getParent();
	}
	if (container == null) {
	    throw new FrameworkException(
		"The CommandField's container must implement Command in " +
		"order to handle the CommandField!", desc, child);
	}

	Map map = new HashMap(1);
	map.put(COMMAND_FIELD_DESCRIPTOR, desc);
	CommandDescriptor commandDesc = new CommandDescriptor((Command)container, desc.getName(), map);
	if (child instanceof BasicCommandField) {
	    // This is the exected way to declare command fields
	    ((BasicCommandField)child).setCommandDescriptor(commandDesc);
	} else if (child instanceof CommandFieldBase) {
	    // This is the old JATO way...
	    if (LogUtil.isLoggable(LogUtil.FINER)) {
		LogUtil.log(LogUtil.FINER, "framework.oldCommandField",
		    child.getName());
	    }
	    ((CommandFieldBase)child).setDescriptor(
		new CommandFieldDescriptor(commandDesc));
	} else {
	    throw new FrameworkException("Unable to add CommandDescriptor " +
		"to CommandField because it is not a 'BasicCommandField'" +
		" or a 'CommandFieldBase'!", desc, child);
	}

	return child;
    }


    /**
     *	This method creates a child for the given container/name/descriptor.
     *	It is implemented as a static method so DescriptorViewBeanBase and
     *	other DescriptorContainerView's can share the same code as it should
     *	be identical.
     */
    public static View createChild(DescriptorContainerView container, String name) {
	// Logging at FINEST
	if (LogUtil.isLoggable(LogUtil.FINEST)) {
	    LogUtil.log(LogUtil.FINEST, "trace.createChild",
		container.getName()+"."+name);
	}

	// Get the RequestContext
	RequestContext ctx = container.getRequestContext();

	// Find the child ViewDescriptor
	ViewDescriptor containerDesc = container.getViewDescriptor();
	ViewDescriptor childDesc = containerDesc.getChildDescriptor(name);

	// **************************************
	// ********** LOCKHART HACK *************
	// **************************************
	// The following code is necessary because Lockhart creates "children"
	// that use "peers".  To make Property Sheets understandable in the
	// ViewXML, the peers must appear to be children.  This is also
	// necessary to correctly associate the Property Sheet fields with the
	// correct Model.
	ViewDescriptor fakeContDesc = null;
	if (childDesc == null) {
	    // There's no descriptor defined for this given child name.
	    // See if it a subChild of one of the descriptors, e.g. CCActionTable or CCPropoertySheet.
// FIXME: BreadCrumb dynamically creates children based on "link*" where * is a number
	    List childDescriptors =
		container.getViewDescriptor().getChildDescriptors();
	    Iterator it = childDescriptors.iterator();
	    while (it.hasNext()) {
		fakeContDesc = (ViewDescriptor)it.next();
		if (fakeContDesc instanceof FakeContainerDescriptor) {
		    childDesc = fakeContDesc.getChildDescriptor(name);
		    if (childDesc != null) {
			break;
		    }
		}
	    }
	}
	// **************************************
	// ******** END LOCKHART HACK ***********
	// **************************************

	// If the Descriptor is still null, we have a problem.
	if (childDesc == null) {
	    throw new ChildNotRegisteredException("Child '"+name+"' does not" +
		" have a registered descriptor in '"+container.getName()+"'!",
		container.getViewDescriptor(), container);
	}

	// Set the correct container
	if (fakeContDesc != null) {
	    // Changing the container to the "FakeContainer" allows
	    // child.getParent() to get the "fake" container
	    View tmp = container.getChild(fakeContDesc.getName());
// FIXME: NOTE: WE have to do the following b/c Lockhart has "FakeContainers"
// FIXME: which don't implement ContainerView.  Specifically, CCBreadCrumb has
// FIXME: children/peers of type HREF, but it does NOT implement containerView
	    if (tmp instanceof ContainerView) {
		// Even fake containers can now create their own children, make
		// them do it so we don't end up doing it 2x (once during
		// registration, once during the JSP)
		return ((ContainerView)tmp).getChild(name);
	    }
	}

	// Make sure "useContainer" is the parent of child ('.'s in the name may
	// have changed this relationship).  NOTE: Even in the unlikely case that
	// a FakeContainer is asked for "a.b.c", this code should still work:
	ContainerView useContainer = container;
	ViewDescriptor tmpDesc = childDesc.getParent();
	Stack stack = new Stack();
	while (tmpDesc != containerDesc) {
	    stack.push(tmpDesc.getName());
	    tmpDesc = tmpDesc.getParent();
	}
	View tmpView = null;
	if (!stack.isEmpty()) {
	    while (!stack.isEmpty()) {
		if (useContainer instanceof DescriptorContainerView) {
		    // container = nearest DescriptorContainerView, maintain this
		    container = (DescriptorContainerView)useContainer;
		}
		tmpView = useContainer.getChild((String)stack.pop());
		if (tmpView instanceof ContainerView) {
		    // This should always be the case, but in LH's world...
		    useContainer = (ContainerView)tmpView;
		}
	    }
            
	    // The following should usually be the case because the child was
	    // most likely already created and we should not create it again.
	    // name should have atleast 1 '.' in it at this point, it is more
	    // than one level deep
            if (useContainer != container)
                return useContainer.getChild(childDesc.getName());
	}

	// Fire our "beforeCreate" event.  This provides a spot for
	// initializing stuff before we create something.  This, of course, is
	// different than beforeDisplay which happens after the child is
	// created.  This is useful for doing Model initialization-type
	// operations.
	DescriptorViewHelper.beforeCreate(ctx,
	    ((useContainer instanceof DescriptorContainerView) ?
		(DescriptorContainerView)useContainer : container), childDesc);

	// Create Child Using the Descriptor
//System.out.println("Creating: '"+useContainer.getName()+"."+name+"'");
	View child = childDesc.getInstance(ctx, useContainer, name);
//System.out.println("Created: '"+useContainer.getName()+"."+name+"'");
	if (child == null) {
	    throw new ChildNullException(name, childDesc, useContainer);
	}

	// If this is a CommandField, add a CommandDescriptor to process click
	addCommandDescriptor(useContainer, child, childDesc);

	// Fire our "afterCreate" event.  This provides a spot for
	// initializing stuff after we create something.  This is useful for
	// doing anything you would like to do once for this View per request
	// and need a reference to the View.  NOTE: The view will be passed in
	// however, this View still has not be registered, therefor calling
	// parent.getChild(view-name) will cause the View to be re-created,
	// which will call this method again, and so on endlessly.
	DescriptorViewHelper.afterCreate(ctx, child, childDesc);

	return child;
    }


    /**
     *	This method is a helper method to handle a "Command".  The Command
     *	implementation may delegate to this method, passing in a ViewBean and
     *	the View (event.getSource()) for the Command event.
     *
     *	@param ctx	The RequestContext.
     *	@param view	The View that is the source of the Command (typically
     *			event.getSource())
     *	@param event	The command event, contains information pertinent to
     *			to the invocation of this command
     *
     *	@throws CommandException	Thrown if an error occurs executing
     *					the command
     */
    public static void execute(RequestContext ctx, View view, CommandEvent event) throws CommandException {
	// Get the DisplayFieldDescriptor
	Map params = event.getParameters();
	DisplayFieldDescriptor desc = (DisplayFieldDescriptor)params.get(
		DescriptorViewHelper.COMMAND_FIELD_DESCRIPTOR);
	try {
	    // Dispatch the event
	    DescriptorViewHelper.dispatchEvent(ctx, view, desc,
		desc.getEventDescriptor(EventDescriptor.TYPES.COMMAND),
		(EventObject)event);

	    // Forward to the next page (if specified)
	    Object nextPage = desc.getParameter(NEXT_PAGE);
	    ViewBean viewbean = null;
	    if (nextPage != null) {
		viewbean =
		    ctx.getViewBeanManager().getViewBean(nextPage.toString());
	    } else {
	    	// Reload the same page.
		viewbean = Util.getParentViewBean(view);
	    }

	    // Make sure we got what we want
	    if (viewbean == null) {
		throw new FrameworkException(
		    "Unable to display next page.  '"+NEXT_PAGE+
		    "' not found!", desc, view);
	    }

	    // Forward to the specified NEXT_PAGE (only if it forwardTo hasn't
	    // been called yet)
	    if (ctx.getRequestPhase() == ctx.SUBMIT_PHASE) {
		viewbean.forwardTo(ctx);
	    }

	    // Fire After Request Event
	    DescriptorViewHelper.dispatchEvent(ctx, view, desc,
		desc.getEventDescriptor(EventDescriptor.TYPES.AFTER_REQUEST),
		(EventObject) event);
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, desc, (View)event.getSource());
	}
    }


    /**
     *	This is a helper method for firing the beforeCreate event.
     *
     *	@param	ctx		The RequestContext
     *	@param	view		The parent view (if null, childDesc will be
     *				event source)
     *	@param	childDesc	The descriptor of the View to be created
     */
    public static void beforeCreate(RequestContext ctx, DescriptorContainerView view, ViewDescriptor childDesc) {
	try {
	    DescriptorViewHelper.dispatchEvent(
		ctx, view, childDesc,
		childDesc.getEventDescriptor(
		    EventDescriptor.TYPES.BEFORE_CREATE),
		new BeforeCreateEvent(view, childDesc));
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, childDesc, view);
	}
    }


    /**
     *	This is a helper method for firing the afterCreate event.
     *
     *	@param	ctx		The RequestContext
     *	@param	view		The View just created
     *	@param	childDesc	The descriptor of the View just created
     */
    public static void afterCreate(RequestContext ctx, View view, ViewDescriptor childDesc) {
	try {
	    DescriptorViewHelper.dispatchEvent(
		ctx, view, childDesc,
		childDesc.getEventDescriptor(
		    EventDescriptor.TYPES.AFTER_CREATE),
		new AfterCreateEvent(view, childDesc));
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, childDesc, view);
	}
    }


    //////////////////////////////////////////////////////////////////////
    //                          Event Methods                           //
    //////////////////////////////////////////////////////////////////////

    /**
     *	Helper method to be used by all DescriptorContainerView
     *	implementations.
     */
    public static void beginDisplay(DescriptorContainerView view, DisplayEvent event) throws ModelControlException {
	if ((view.getParent() != null) &&
		(view.getParent() instanceof DescriptorContainerView)) {
	    // Skip this one b/c container views invoke beginDisplay on their
	    // own + parent invokes beginChildDisplay.  Don't do handlers 2x
	    //
	    // NOTE: we DO NOT skip Views in which their parent is NOT a
	    // DescriptorContainerView... since thier container is NOT a
	    // DescriptorContainerView, the container would NOT have performed
	    // the declared beginDisplay handlers.
	    return;
	}
	try {
	    // Dispatch Begin Display Event Handlers (and mappings)
	    ViewDescriptor vd = view.getViewDescriptor();
	    DescriptorViewHelper.dispatchEvent(
		view.getRequestContext(),
		view,
		vd,
		vd.getEventDescriptor(EventDescriptor.TYPES.BEGIN_DISPLAY),
		(EventObject)event);
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, view.getViewDescriptor(), view);
	}
    }


    /**
     *
     */
    public static boolean beginChildDisplay(DescriptorContainerView view, ChildDisplayEvent event) throws ModelControlException {
	Object result = null;

	String childName = event.getChildName();

	// Get the child descriptor that defines the EventHandlers
	ViewDescriptor childDesc =
	    view.getViewDescriptor().getChildDescriptor(childName);
	if (childDesc != null) {
	    // NOTE: tags like CCHtmlHeaderTag do not have corresponding View's
	    // NOTE: For these, we will just use the container
	    View child = null;
	    try {
		child = (childName == null) ? (view) : (view.getChild(childName));
	    } catch (Exception ex) {
	    }

	    // If we couldn't obtain a child, use container
	    if (child == null) {
		child = view;
	    }

	    try {
		result = DescriptorViewHelper.dispatchEvent(
		    view.getRequestContext(),
		    child,
		    childDesc,
		    childDesc.getEventDescriptor(
			    EventDescriptor.TYPES.BEGIN_DISPLAY),
		    (EventObject)event);
	    } catch (CompleteRequestException ex) {
		// Let this exception be caught by the Servlet
		throw ex;
	    } catch (FrameworkException ex) {
		// Change to an error
		throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	    } catch (Exception ex) {
		throw new FrameworkError(ex, childDesc, child);
	    }
	}

	boolean retVal = true;
	if (result instanceof Boolean) {
	    retVal = ((Boolean)result).booleanValue();
	}
	return retVal;
    }


    /**
     *
     */
    public static String endChildDisplay(DescriptorContainerView view, ChildContentDisplayEvent event) throws ModelControlException {
	Object result = null;

	// Get the child descriptor that defines the EventHandlers
	String childName = event.getChildName();

	ViewDescriptor childDesc =
	    view.getViewDescriptor().getChildDescriptor(childName);
	if (childDesc != null) {
	    // NOTE: tags like CCHtmlHeaderTag do not have corresponding View's
	    // NOTE: For these, we will just use the container
	    View child = null;
	    try {
		child = (childName == null) ? (view) : (view.getChild(childName));
	    } catch (Exception ex) {
	    }

	    // If we couldn't obtain a child, use container
	    if (child == null) {
		child = view;
	    }

	    try {
		result = DescriptorViewHelper.dispatchEvent(
		    view.getRequestContext(),
		    child,
		    childDesc,
		    childDesc.getEventDescriptor(
			    EventDescriptor.TYPES.END_DISPLAY),
		    (EventObject)event);
	    } catch (CompleteRequestException ex) {
		// Let this exception be caught by the Servlet
		throw ex;
	    } catch (FrameworkException ex) {
		// Change to an error
		throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	    } catch (Exception ex) {
		throw new FrameworkError(ex, childDesc, child);
	    }
	}
	return (result == null) ? event.getContent() : result.toString();
    }


    /**
     *
     */
    public static void endDisplay(DescriptorContainerView view, DisplayEvent event) {
	if ((view.getParent() != null) && 
		(view.getParent() instanceof DescriptorContainerView)) {
	    // Skip this one b/c container views invoke EndDisplay on their
	    // own + parent invokes endChildDisplay.  Don't do handlers 2x
	    return;
	}
	try {
	    ViewDescriptor vd = view.getViewDescriptor();
	    DescriptorViewHelper.dispatchEvent(
		view.getRequestContext(),
		view,
		vd,
		vd.getEventDescriptor(EventDescriptor.TYPES.END_DISPLAY),
		(EventObject)event);
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, view.getViewDescriptor(), view);
	}
    }


    /**
     *
     */
    public static boolean endWizard(ViewDescriptor viewDesc, WizardEvent event) throws ModelControlException {
	Object result = null;
        try {
	    // Dispatch Begin Display Event Handlers (and mappings)
	    result = DescriptorViewHelper.dispatchEvent(
		event.getRequestContext(),
		null,
		viewDesc,
		viewDesc.getEventDescriptor(EventDescriptor.TYPES.END_WIZARD),
		new EventObject(event));
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, viewDesc, null);
	}

	boolean retVal = true;
	if (result instanceof Boolean) {
	    retVal = ((Boolean)result).booleanValue();
	}
        return retVal;
    }


    /**
     *
     */
    public static boolean nextWizardStep(DescriptorContainerView view, WizardEvent event) throws ModelControlException {
	Object result = null;
	try {
	    ViewDescriptor vd = view.getViewDescriptor();
	    result = DescriptorViewHelper.dispatchEvent(
		view.getRequestContext(),
		view,
		vd,
		vd.getEventDescriptor(EventDescriptor.TYPES.NEXT_WIZARD_STEP),
		new EventObject(event));
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, view.getViewDescriptor(), view);
	}
	boolean retVal = true;
	if (result instanceof Boolean) {
	    retVal = ((Boolean)result).booleanValue();
	}
        return retVal;
    }


    /**
     *
     */
    public static boolean prevWizardStep(DescriptorContainerView view, WizardEvent event) throws ModelControlException {
	Object result = null;
	try {
	    ViewDescriptor vd = view.getViewDescriptor();
	    result = DescriptorViewHelper.dispatchEvent(
		view.getRequestContext(),
		view,
		vd,
		vd.getEventDescriptor(EventDescriptor.TYPES.PREV_WIZARD_STEP),
		new EventObject(event));
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, view.getViewDescriptor(), view);
	}
	boolean retVal = true;
	if (result instanceof Boolean) {
	    retVal = ((Boolean)result).booleanValue();
	}
        return retVal;
    }


    /**
     *
     */
    public static boolean goToWizardStep(DescriptorContainerView view, WizardEvent event) throws ModelControlException {
	Object result = null;
	try {
	    ViewDescriptor vd = view.getViewDescriptor();
	    result = DescriptorViewHelper.dispatchEvent(
		view.getRequestContext(),
		view,
		vd,
		vd.getEventDescriptor(EventDescriptor.TYPES.GOTO_WIZARD_STEP),
		new EventObject(event));
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, view.getViewDescriptor(), view);
	}
	boolean retVal = true;
	if (result instanceof Boolean) {
	    retVal = ((Boolean)result).booleanValue();
	}
        return retVal;
    }


    /**
     *
     */
    public static boolean finishWizardStep(DescriptorContainerView view, WizardEvent event) throws ModelControlException {
	Object result = null;
	try {
	    ViewDescriptor vd = view.getViewDescriptor();
	    result = DescriptorViewHelper.dispatchEvent(
		view.getRequestContext(),
		view,
		vd,
		vd.getEventDescriptor(EventDescriptor.TYPES.FINISH_WIZARD_STEP),
		new EventObject(event));
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (Exception ex) {
	    throw new FrameworkException(ex, view.getViewDescriptor(), view);
	}
	boolean retVal = true;
	if (result instanceof Boolean) {
	    retVal = ((Boolean)result).booleanValue();
	}
        return retVal;
    }


    /**
     *
     */
    public static boolean cancelWizardStep(DescriptorContainerView view, WizardEvent event) throws ModelControlException {
	Object result = null;
	try {
	    ViewDescriptor vd = view.getViewDescriptor();
	    result = DescriptorViewHelper.dispatchEvent(
		view.getRequestContext(),
		view,
		vd,
		vd.getEventDescriptor(EventDescriptor.TYPES.CANCEL_WIZARD_STEP),
		new EventObject(event));
	} catch (CompleteRequestException ex) {
	    // Let this exception be caught by the Servlet
	    throw ex;
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(ex, ex.getResponsibleViewDescriptor(), ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, view.getViewDescriptor(), view);
	}
	boolean retVal = true;
	if (result instanceof Boolean) {
	    retVal = ((Boolean)result).booleanValue();
	}
        return retVal;
    }


    /**
     *	This method performs mappings.  Besides the RquestContext, a List of
     *	MappingDescriptor objects is required.  This method will iterate over
     *	the MappingDescriptor objects. For each MappingDescriptor, a source
     *	object will be obtained and set on the target as described by the
     *	MappingDescriptor.
     *
     *	@param reqCtx	The RequestContext
     *	@param mappings	The Mappings to perform
     * /
    protected static void doMappings(RequestContext reqCtx, List mappings) {
	if ((mappings == null) || (mappings.size() < 1)) {
	    return;
	}
	MappingDescriptor mapping = null;
	Object source = null;

	Iterator iter = mappings.iterator();
	while (iter.hasNext()) {
	    // Iterate through each mapping and push the source object
	    // to the target
	    mapping = (MappingDescriptor)iter.next();
	    if (mapping.hasPermission(reqCtx)) {
		try {
		    source = mapping.getSource().getMappedSource(
			reqCtx, mapping, mapping.getSourceParameters());
		    mapping.getTarget().setMappedTarget(
			reqCtx, mapping, mapping.getTargetParameters(), source);
		} catch (Exception ex) {
		    if (mapping == null) {
			throw new FrameworkException("(null) MappingDescriptor object included in list of mappings!", ex);
		    }
		    Object src = mapping.getSource();
		    if (src == null) {
			src = "(null)";
		    } else {
			src = src.getClass().getName();
		    }
		    Object target = mapping.getTarget();
		    if (target == null) {
			target = "(null)";
		    } else {
			target = target.getClass().getName();
		    }
		    throw new FrameworkException("Mapping from '"+src+"' to '"+target+"' failed!", ex);
		}
	    }
	}
    }
    */


    /**
     *	This method handles the dispatching of Events.  The given
     *	EventDescriptor will contain zero or more event handlers.  Each of
     *	these event handlers are invoked sequentially.  If 1 or more of these
     *	event handlers provide a return value, the last non-null return value
     *	will be returned from this method.  Before and after each event handler
     *	is invoked, before and after mappings are performed respectively.
     *
     *	@param	reqCtx		The RequestContext
     *
     *	@param	view		The View to pass to the handler
     *
     *	@param	eventDesc	The EventDescriptor which describes the event
     *				and how to handle it
     *
     *	@param	event		The event itself (generated interally by JATO)
     *
     *	@return	Some events have return values.  If one of the handlers returns
     *		a value, then that value will be returned.  If more than 1
     *		handler returns a value, the last non-null value will be
     *		returned.
     */
    public static Object dispatchEvent(RequestContext reqCtx, View view, ViewDescriptor vd, EventDescriptor eventDesc, EventObject event) {
	Object result = null;

	// Make sure we have something to do
	if (eventDesc == null) {
	    return result;
	}
	try {
	    // Invoke all the handlers
	    result = invokeHandlers(reqCtx, view, vd, event, eventDesc.getEventHandlers());
	} catch (Exception ex) {
	    if (ex instanceof java.lang.reflect.InvocationTargetException) {
		// Since reflection is used to invoke the handler, our exception will be
		// wrapped... check for CompleteRequestException, if found throw it to
		// be caught by the Servlet
		Throwable root = ex.getCause();
		if (root instanceof CompleteRequestException) {
		    throw (CompleteRequestException) root;
		}
	    }
	    throw new FrameworkException(
		ex.getClass().getName() + " while attempting to " +
		"process a '" + eventDesc.getType() + "' event for '" +
		eventDesc.getParent().getName() + "'.",
		ex, eventDesc.getParent(), view);
	}

	// Return the result (if any)
	return result;
    }


    /**
     *
     */
    private static Object invokeHandlers(RequestContext ctx, View view, ViewDescriptor vd, EventObject event, List useHandlerDescs) throws InstantiationException, IllegalAccessException, InvocationTargetException {
	Object result = null;
	Object retVal = null;

	Iterator it = useHandlerDescs.iterator();
	UseHandlerDescriptor handler = null;
	while (it.hasNext()) {
	    handler = (UseHandlerDescriptor)it.next();
	    retVal = invokeHandler(ctx, handler, view, vd, event);
	    if (retVal != null) {
		result = retVal;
	    }
	}

	return result;
    }


    /**
     *	This method creates a HandlerContext.  If for any reason you want to
     *	customize how a handler is created, let me know I can add this feature.
     */
    protected static HandlerContext createHandlerContext(UseHandlerDescriptor useHandler, HandlerDescriptor handler, View view, ViewDescriptor vd, EventObject event) {
	return new HandlerContextImpl(useHandler, handler, view, vd, event);
    }


    /**
     *
     */
    protected static Object invokeHandler(RequestContext ctx, UseHandlerDescriptor handler, 
            View view, ViewDescriptor vd, EventObject event) 
        throws InstantiationException, IllegalAccessException, InvocationTargetException {
            
	HandlerDescriptor handlerDef = handler.getHandlerDescriptor();
	Method method = handlerDef.getHandlerMethod();
                
	Object retVal = null;
	Object result = null;

	// Logging at FINER for tracing information
	if (LogUtil.isLoggable(LogUtil.FINER)) {
	    LogUtil.log(LogUtil.FINER, "trace.invoke", handlerDef.getName());
	}

	// Check permissions
	if (handler.hasPermission(vd) && handlerDef.hasPermission(vd)) {
	    // First execute all child handlers
	    result = invokeHandlers(
		ctx, view, vd, event, handlerDef.getChildHandlerDescriptors());

	    // Create the HandlerContext object
	    HandlerContext handlerCtx = createHandlerContext(handler, handlerDef, view, vd, event);

	    // Only attempt to do this if there is a handler method, there
	    // might only be child handlers
	    if (method != null) {
// FIXME: We might want to consider using static methods, or providing an
// FIXME: interface for getting an instance of these classes... not sure if we
// FIXME: want to share instances (singleton) or not.  For now I'll just create
// FIXME: a new instance each time.

		// Get the class that contains the method
		Object instance = method.getDeclaringClass().newInstance();

		// Logging at FINER for tracing information
		if (LogUtil.isLoggable(LogUtil.FINER)) {
		    LogUtil.log(LogUtil.FINER, "trace.invoke",
			instance.getClass().getName()+"."+method.getName());
		}

		retVal = method.invoke(instance, new Object[] {ctx, handlerCtx});
		if (retVal != null) {
		    result = retVal;
		}
	    }
	} else if (LogUtil.isLoggable(LogUtil.FINER)) {
	    // Tracing at FINER
	    String ifName = (vd.getParent() == null) ?
		("") : (vd.getParent().getName()+".");
	    ifName += vd.getName()+"."+handlerDef.getName();
	    LogUtil.log(LogUtil.FINER, "trace.ifFailed", ifName);
	}

	// Return the result (null if no result)
	return result;
    }


    /**
     *
     */
    protected static void verifyClassExists(ServletContext sc, String fileName) throws ClassNotFoundException {
	String className = null;
	if (fileName.endsWith(".jsp")) {
	    className = fileName.substring(0,fileName.lastIndexOf(".jsp")) + "_jsp";
	    className = className.replaceAll("/", "._");
	    className = "_jasper" + className;

	    try {
		Class clazz = Class.forName(className);
		return;
	    } catch (ClassNotFoundException ex) {
	    } catch (Exception ex) {
	    }
	}
	if (sc != null) {
	    // look for the file itself
	    String path = sc.getRealPath(fileName);
	    File f = new File(path);
	    if (f.exists() == false) {
		if (LogUtil.isLoggable(LogUtil.FINE)) {
		    if (className != null) {
			LogUtil.log(LogUtil.FINE, "framework.classNotFound",
			    className);
		    } else {
			LogUtil.log(LogUtil.FINE, "framework.fileNotFound",
			    path);
		    }
		}
		throw new ClassNotFoundException((className == null) ? path : className);
	    }
	} else {
	    throw new RuntimeException("ServletContext is null!");
	}
    }


    /**
     *
     */
    public static final String NEXT_PAGE		= "nextPage";


    /**
     *
     */
    public static final String COMMAND_FIELD_DESCRIPTOR = "CommandField";
}
