/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.BasicDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;


/**
 *
 */
public class BasicDisplayFieldDescriptor extends DisplayFieldDescriptor {

    /**
     *
     */
    public BasicDisplayFieldDescriptor(String name) {
	super(name);
    }


    /**
     *	This is a factory method for BasicDisplayField instances.  It uses the
     *	DisplayField DEFAULT_VALUE ("defaultValue") parameter for setting its
     *	initial value.
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the new BasicDisplayField
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	// Create the field
	BasicDisplayField field = new BasicDisplayField(container, name);

	// Set the ModelFieldBinding
	setModelFieldBinding(field, getModelFieldName());

	// Set the default value if supplied
	setDefaultValue(field);

	return field;
    }
}
