/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.DescriptorCCPrimaryMasthead;
import com.sun.web.ui.model.CCMastheadModel;
import com.sun.web.ui.model.CCMastheadModelInterface;


/**
 *
 */
public class CCPrimaryMastheadDescriptor extends DisplayFieldDescriptor {

    /**
     *	Constructor
     */
    public CCPrimaryMastheadDescriptor(String name) {
	super(name);
    }

    /**
     *	<p> This method retrieves the CCMastheadModelInterface
     *	    implementation.  If the Model is new, it will attempt to populate
     *	    it via parameters supplied via the XML.  If you want to populate
     *	    the model via code, you can do that as well.</p>
     *
     *	@return The CCMastheadModel from the ModelManager.
     */
    public CCMastheadModelInterface getModel() {
	// Determine if the session should be used w/ the model manager.
	boolean fromSession = shouldGetModelFromSession();
	boolean toSession = shouldPutModelToSession();
	String value = getModelInstanceName();

	// Use the ModelManager to create/get the model
	ModelManager mgr = RequestManager.getRequestContext().getModelManager();
	// Using the instance class b/c I'm too lazy to register the mapping
	CCMastheadModelInterface model =
	    (CCMastheadModelInterface) mgr.getModel(CCMastheadModel.class,
		value, fromSession, toSession);

	// Use model.getShowDate() to see if we need to populate the model
	if (model.getShowDate() != null) {
	    // Model already populated, return it
	    return model;
	}

	//help
	String helpFile = (String) getParameter(HELP_FILENAME);
	if (helpFile != null) {
	    ((CCMastheadModel) model).setHelpFileName(helpFile);
	}

	// Set CCMastheadModel.showDate()
	value = (String) getParameter(SHOW_DATE);
	if (value == null) {
	    value = "false";
	}
	model.setShowDate(new Boolean(value).booleanValue());

	// Set the taskStatusHref
	value = (String) getParameter(TASK_STATUS_HREF);
	if (value != null) {
	    model.setTaskStatusHREF(value);
	}

	// Set the currentAlarmsHref
	value = (String) getParameter(CURRENT_ALARMS_HREF);
	if (value != null) {
	    model.setCurrentAlarmsHREF(value);
	}

	// Set the alarmCountHref
	value = (String) getParameter(ALARM_COUNT_HREF);
	if (value != null) {
	    model.setAlarmCountHREF(value);
	}

	// Set the number of tasks running
	value = (String) getParameter(NUM_TASKS);
	if (value != null) {
	    model.setNumTasks(Integer.parseInt(value));
	}

	// Set the number of tasks running
	value = (String) getParameter(NUM_DOWN);
	if (value != null) {
	    ((CCMastheadModel) model).setAlarms(
		value,
		(String) getParameter(NUM_CRITICAL),
		(String) getParameter(NUM_MAJOR),
		(String) getParameter(NUM_MINOR));
	}

	// Add arbitrary links
	int count = 0;
	value = (String) getParameter(LINK + count);
	while (value != null) {
	    model.addLink(
		value,
		(String) getParameter(LINK_LABEL + count),
		(String) getParameter(LINK_TOOLTIP + count),
		(String) getParameter(LINK_STATUS + count));
	    count++;
	    value = (String) getParameter(LINK + count);
	}

	// Show Server
	value = (String) getParameter(SHOW_SERVER);
	if (value != null) {
	    model.setShowServer(Boolean.valueOf(value));
	}

	// Show User Role
	value = (String) getParameter(SHOW_USER_ROLE);
	if (value != null) {
	    model.setShowUserRole(Boolean.valueOf(value));
	}

	// Image
	String imageSrc = (String) getParameter(IMAGE_SRC);
	if (imageSrc != null) {
	    model.setSrc(imageSrc);
	}

	//Version
	String versionFile  = (String) getParameter(VERSION_FILE);
	if (versionFile != null) {
	    ((CCMastheadModel) model).setVersionFileName(versionFile);
	}

	String versionWindowHeight = (String) getParameter(VERSION_WINDOW_HEIGHT);
	if (versionWindowHeight != null) {
	    ((CCMastheadModel) model).setVersionHeight(versionWindowHeight);
	}

	String versionWindowWidth = (String) getParameter(VERSION_WINDOW_WIDTH);
	if (versionWindowWidth != null) {
	    ((CCMastheadModel) model).setVersionWidth(versionWindowWidth);
	}

	String prodNameSrc = (String) getParameter(PRODUCT_NAME_SRC);
	if (prodNameSrc != null) {
	    ((CCMastheadModel) model).setVersionProductNameSrc(prodNameSrc);
	}

	String prodNameHeight = (String) getParameter(PRODUCT_NAME_HEIGHT);
	if (prodNameHeight != null) {
	    ((CCMastheadModel) model).setVersionProductNameHeight(prodNameHeight);
	}

	String prodNameWidth = (String) getParameter(PRODUCT_NAME_WIDTH);
	if (prodNameWidth != null) {
	    ((CCMastheadModel) model).setVersionProductNameWidth(prodNameWidth);
	}

	//Help
	String helpType = (String) getParameter(HELP_TYPE);
	if (helpType == null) {
	    helpType = DEFAULT_HELP_TYPE;
	}
	((CCMastheadModel) model).setHelpType(helpType);

	String helpMastheadTitle = (String) getParameter(HELP_MASTHEADTITLE);
	if (helpMastheadTitle != null) {
	    ((CCMastheadModel) model).setHelpMastheadTitle(helpMastheadTitle);
	}

	// Return the model
	return model;
    }

    /**
     *	This is a factory method for DescriptorCCPrimaryMasthead instances.
     *
     *	@param	ctx	    The RequestContext
     *	@param	container   The container for the newly created
     *	@param	name	    The instance name
     *
     *	@return	A DescriptorCCPrimaryMasthead instance.
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	// Create the DescriptorCCPrimaryMasthead
	DescriptorCCPrimaryMasthead mh = new DescriptorCCPrimaryMasthead(
		ctx, container, name, this, getModel());

	// Set View parameters
	// Set CCMastheadModel.showDate()
	String value = (String) getParameter(SUBMIT_FORM_DATA);
	if (value == null) {
	    value = "false";
	}
	mh.setSubmitFormData(new Boolean(value).booleanValue());

	// Set the userInfoHref
	value = (String) getParameter(USER_INFO_HREF);
	if (value != null) {
	    mh.setUserInfoHREF(value);
	}

	// Set the notificationMsg
	value = (String) getParameter(NOTIFICATION_MSG);
	if (value != null) {
	    mh.setNotificationMsg(value);
	}

	// Set the notificationHref
	value = (String) getParameter(NOTIFICATION_HREF);
	if (value != null) {
	    mh.setNotificationHREF(value);
	}

	value = (String) getParameter(USER_NAME);
	if (value != null) {
	    mh.setUserName(value);
	}

	// Return the CCPrimaryMastHead instance
	return mh;
    }

    /**
     *	<p> This parameter (showDate) should be set to "true" to set the
     *	    CCMastheadModel.showDate(true), else false will be used.</p>
     */
    public static final String	SHOW_DATE	    = "showDate";

    /**
     *	<p> This parameter (taskStatusHref) should be set to the name of the
     *	    href for task status.  If supplied, this will be set via
     *	    CCMastheadModel.setTaskStatusHREF(String).</p>
     */
    public static final String	TASK_STATUS_HREF    = "taskStatusHref";

    /**
     *	<p> This parameter (currentAlarmsHref) should be set to the name of the
     *	    currentAlarmsHref child.  If supplied, this will be set via
     *	    CCMastheadModel.setCurrentAlarmsHREF(String).</p>
     */
    public static final String	CURRENT_ALARMS_HREF = "currentAlarmsHref";

    /**
     *	<p> This parameter (alarmCountHref) should be set to the name of the
     *	    alarmCountHref child.  If supplied, this will be set via
     *	    CCMastheadModel.setAlarmCountHREF(String).</p>
     */
    public static final String	ALARM_COUNT_HREF    = "alarmCountHref";

    /**
     *	<p> This parameter (numTasks) should be set to the number of the
     *	    current running tasks.  If supplied, this will be set via
     *	    CCMastheadModel.setNumTasks(int).</p>
     */
    public static final String	NUM_TASKS	    = "numTasks";

    /**
     *	<p> This parameter (numDown) reflects the down alarm count.  It will
     *	    be passed to CCMastHeadModel.setAlarms(String, String, String,
     *	    String) as the first argument.</p>
     */
    public static final String	NUM_DOWN	    = "numDown";

    /**
     *	<p> This parameter (numCritical) reflects the critical alarm count.  It
     *	    will be passed to CCMastHeadModel.setAlarms(String, String,
     *	    String, String) as the second argument.</p>
     */
    public static final String	NUM_CRITICAL	    = "numCritical";

    /**
     *	<p> This parameter (numMajor) reflects the major alarm count.  It will
     *	    be passed to CCMastHeadModel.setAlarms(String, String, String,
     *	    String) as the third argument.</p>
     */
    public static final String	NUM_MAJOR	    = "numMajor";

    /**
     *	<p> This parameter (numMinor) reflects the minor alarm count.  It will
     *	    be passed to CCMastHeadModel.setAlarms(String, String, String,
     *	    String) as the fourth argument.</p>
     */
    public static final String	NUM_MINOR	    = "numMinor";

    /**
     *	<p> This parameter name (link) will have a number 0 through n
     *	    appended to it where n represents the last general link added to
     *	    the Masthead.  Link numbers must be sequential.  The value for
     *	    this parameter will be the href child name.</p>
     */
    public static final String	LINK		    = "link";

    /**
     *	<p> This parameter name (linkLabel) will have a number 0 through n
     *	    appended to it where n represents the last general link added to
     *	    the Masthead.  Link numbers must be sequential.  The value for
     *	    this parameter will be the href child label.</p>
     */
    public static final String	LINK_LABEL	    = "linkLabel";

    /**
     *	<p> This parameter name (linkTooltip) will have a number 0 through n
     *	    appended to it where n represents the last general link added to
     *	    the Masthead.  Link numbers must be sequential.  The value for
     *	    this parameter will be the href child tooltip.</p>
     */
    public static final String	LINK_TOOLTIP	    = "linkTooltip";

    /**
     *	<p> This parameter name (linkStatus) will have a number 0 through n
     *	    appended to it where n represents the last general link added to
     *	    the Masthead.  Link numbers must be sequential.  The value for
     *	    this parameter will be the href child status.</p>
     */
    public static final String	LINK_STATUS	    = "linkStatus";

    /**
     *	<p> The value for parameter (submitFormData) is passed to
     *	    CCPrimaryMasthead.setSubmitFormData(boolean).  The default is
     *	    false.</p>
     */
    public static final String	SUBMIT_FORM_DATA    = "submitFormData";

    /**
     *	<p> This parameter (userInfoHref) should be set to the name of the
     *	    userInfoHref child.  If supplied, this will be set via
     *	    CCPrimaryMasthead.setUserInfoHREF(String).</p>
     */
    public static final String	USER_INFO_HREF	    = "userInfoHref";

    /**
     *	<p> This parameter (notificationMsg) should be set to the
     *	    notificationMsg value.  If supplied, this will be set via
     *	    CCPrimaryMasthead.setNotificationMsg(String).</p>
     */
    public static final String	NOTIFICATION_MSG    = "notificationMsg";

    /**
     *	<p> This parameter (notificationHref) should be set to the name of the
     *	    notificationHref child.  If supplied, this will be set via
     *	    CCPrimaryMasthead.setNotificationHREF(String).</p>
     */
    public static final String	NOTIFICATION_HREF   = "notificationHref";

    /**
     *	<p> This parameter (productNameSrc) should be set to the path of the
     *	    product name gif file. If supplied this will be set via
     *	    CCHelpVersionInterface.setVersionProductNameSrc method
     */
    public static final String PRODUCT_NAME_SRC	    = "productNameSrc";

    /**
     *	<p> This parameter (productNameHeight) should be set to the height of the
     *	    product name gif file. If supplied this will be set via
     *	    CCHelpVersionInterface.setVersionProductNameHeight method
     */
    public static final String PRODUCT_NAME_HEIGHT  = "productNameHeight";

    /**
     *	<p> This parameter (productNameWidth) should be set to the width of the
     *	    product name gif file. If supplied this will be set via
     *	    CCHelpVersionInterface.setVersionProductNameWidth method
     */
    public static final String PRODUCT_NAME_WIDTH   = "productNameWidth";

    /**
     *	<p> This parameter (versionFile) should be set to the path of the
     *	    version file. If supplied this will be set via
     *	    CCHelpVersionInterface.setVersionFile method
     *	    Also see CCVersionWindowTag API Help for more info on the localization of
     *	    the file
     *
     *	    HACK: setting this as a relative path to the top level file which calls a JSP
     *	    for the localized copyright message
     */
    public static final String VERSION_FILE		= "versionFile";

    public static final String SHOW_SERVER		= "showServer";
    public static final String SHOW_USER_ROLE		= "showUserRole";
    public static final String IMAGE_SRC		= "imageSrc";

    public static final String VERSION_WINDOW_HEIGHT	= "versionWindowHeight";
    public static final String VERSION_WINDOW_WIDTH	= "versionWindowWidth";
    public static final String USER_NAME		= "userName";

    //HELP
    public static final String HELP_MASTHEADTITLE	= "helpMastheadTitle";
    public static final String HELP_TYPE		= "helpType";
    public static final String DEFAULT_HELP_TYPE	= "help2";
    public static final String HELP_FILENAME		= "helpFile";
    public static final String HELP_RESOURCES		= "helpResources";
}
