/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.event;

import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.util.EventObject;


/**
 *  This event object will be created and used prior to any child being
 *  created.  This provides a place to initialize things that may be needed for
 *  object creation (such as populating a Model).  The source for this event
 *  will be the parent container, or the ViewDescriptor if there is no parent
 *  container (I know this is inconsistent, however, null is not allowed).  The
 *  parent container should always be an instanceof DescriptorContainerView.
 */
public class BeforeCreateEvent extends EventObject {

    /**
     *	This is the constructor for a BeforeCreateEvent.  You must specify the
     *	ViewDescriptor (the ViewDescriptor of the View that is about to be
     *	created).  You should specify the container unless this is a ViewBean,
     *	in which case null may be passed in.  If null is passed, the source
     *	event source will be the descriptor instead of the null View (this is
     *	because null is not allowed as a source).
     *
     *	@param	src	The containing DescriptorContainerView
     *	@param	desc	The ViewDescriptor for the View to be created
     */
    public BeforeCreateEvent(DescriptorContainerView src, ViewDescriptor desc) {
	super((src == null) ? (Object)desc : (Object)src);
	setViewDescriptor(desc);
    }


    /**
     *	This method sets the ViewDescriptor for the object that is about to be
     *	created.
     *
     *	@param	viewDesc	The ViewDescriptor of the View to be created.
     */
    protected void setViewDescriptor(ViewDescriptor viewDesc) {
	if (viewDesc == null) {
	    throw new IllegalArgumentException(
		"You must specify a ViewDescriptor when creating a "+
		"BeforeCreateEvent object!");
	}
	_viewDesc = viewDesc;
    }


    /**
     *	This method retrieves the ViewDescriptor of the View that is about to
     *	be created.  The ViewDescriptor may have necessary information in order
     *	to do what you have to do before the View is created.
     *
     *	@return The ViewDescriptor for the View about to be created.
     */
    public ViewDescriptor getViewDescriptor() {
	return _viewDesc;
    }


    /**
     *	This method returns the name of the View that is about to be created.
     *
     *	@return The name of the view to be created.
     */
    public String getName() {
	return getViewDescriptor().getName();
    }


    private ViewDescriptor _viewDesc = null;
}
