/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/AuthRealmConfigFactory.java,v 1.9 2006/03/09 20:30:36 llc Exp $
 * $Revision: 1.9 $
 * $Date: 2006/03/09 20:30:36 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Properties;

import javax.management.ObjectName;

import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.AuthRealmConfig;
import static com.sun.appserv.management.config.AuthRealmConfig.*;

import com.sun.appserv.management.util.misc.StringUtil;

import com.sun.enterprise.management.support.oldconfig.OldSecurityServiceMBean;
import com.sun.enterprise.management.support.oldconfig.OldConfigsMBean;

import com.sun.enterprise.security.auth.realm.file.FileRealm;

/**
 */
public final class AuthRealmConfigFactory extends ConfigFactory
{
		public
	AuthRealmConfigFactory(final ConfigFactoryCallback callbacks)
	{
		super( callbacks );
		
		assert( FileRealm.JAAS_CONTEXT_PARAM.equals(
		    StringUtil.stripPrefix( JAAS_CONTEXT_PROPERTY_KEY,
		            PropertiesAccess.PROPERTY_PREFIX ) ) );
		            
		assert( FileRealm.PARAM_KEYFILE.equals(
		    StringUtil.stripPrefix( KEY_FILE_PROPERTY_KEY,
		            PropertiesAccess.PROPERTY_PREFIX ) ) );
	}
	
		private final OldSecurityServiceMBean
	getOldSecurityServiceMBean(  )
	{
		final OldSecurityServiceMBean	oldSecurityService =
			getOldConfigProxies().getOldSecurityServiceMBean( getConfigName() );
		return( oldSecurityService );
	}
	
		private final OldConfigsMBean
	getOldConfigsMBean(  )
	{
		final OldConfigsMBean	oldConfigs =
			getOldConfigProxies().getOldConfigsMBean();
		return( oldConfigs );
	}
	
	
	static final	String	CLASSNAME_KEY		= "Classname";
	
	    private void
	checkDefaultProps( final Map<String,String> optional )
	{
        final String    keyFile = optional == null ?
                            null : (String)optional.get( KEY_FILE_PROPERTY_KEY );
        if ( keyFile == null )
        {
            throw new IllegalArgumentException(
                "Must specify a key file using KEY_FILE_PROPERTY_KEY in options Map" );
        }
        
        final String    jaasContext = optional == null ?
                            null : (String)optional.get( JAAS_CONTEXT_PROPERTY_KEY );
        if ( jaasContext == null )
        {
            throw new IllegalArgumentException(
                "Must specify a JAAS context file using JAAS_CONTEXT_PROPERTY_KEY in options Map" );
        }
	}
	
		public ObjectName	
    create(
        final String name,
        final String className,
        final Map<String,String> optional )
	{
	    if ( className.equals( DEFAULT_REALM_CLASSNAME ) )
	    {
	        checkDefaultProps( optional );
	    }
	    
		final String[] requiredParams = { CLASSNAME_KEY, className,	};

		final Map<String,String> params =
		    initParams( name, requiredParams, optional );

		final ObjectName amxName = createNamedChild( name, params );

		return amxName;
	}

	

		protected final void		
	removeByName( final String authLayer )
	{
		getOldSecurityServiceMBean().removeAuthRealmByName( authLayer );
	}

	/**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig(
	    final AttributeList translatedAttrs,
	    final Properties    props )
	{
		final String	target	= getConfigName();
		
		final ObjectName	objectName	=
		    getOldConfigsMBean().createAuthRealm(
		        translatedAttrs, props, target);
		
		return( objectName );
	}
}







