/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/ConnectorConnectionPoolConfigFactory.java,v 1.4 2006/03/09 20:30:37 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:37 $
 */


package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Properties;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.ObjectName;

import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.ResourceAdapterConfig;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.appserv.management.config.ConnectorConnectionPoolConfigKeys;
import com.sun.appserv.management.config.CommonConfigKeys;

/**
	MBean managing all instances of Connector resource.
 */

public final class ConnectorConnectionPoolConfigFactory  extends ResourceFactoryImplBase
	// implements ConnectorConnectionPoolConfigMgr
{
		public
	ConnectorConnectionPoolConfigFactory( final ConfigFactoryCallback	callbacks)
	{
		super( callbacks );
	}
     
		
	/**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs )
	{
		return( getOldResourcesMBean().createConnectorConnectionPool( translatedAttrs ) );
	}
	
	
	public static final String	CONNECTION_DEFINITION_NAME_KEY	= "ConnectionDefinitionName";
	public static final String	RESOURCE_ADAPTER_NAME_KEY	= "ResourceAdapterName";
	
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		ConnectorConnectionPoolConfigKeys.STEADY_POOL_SIZE_KEY,
		ConnectorConnectionPoolConfigKeys.MAX_POOL_SIZE_KEY,
		ConnectorConnectionPoolConfigKeys.MAX_WAIT_TIME_IN_MILLIS_KEY,
		ConnectorConnectionPoolConfigKeys.POOL_RESIZE_QUANTITY_KEY,
		ConnectorConnectionPoolConfigKeys.IDLE_TIMEOUT_IN_SECONDS_KEY,
		ConnectorConnectionPoolConfigKeys.FAIL_ALL_CONNECTIONS_KEY,
		ConnectorConnectionPoolConfigKeys.TRANSACTION_SUPPORT_KEY,
		ConnectorConnectionPoolConfigKeys.TRANSACTION_SUPPORT_KEY,
		CommonConfigKeys.IGNORE_MISSING_REFERENCES_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
		private void
	checkResourceAdapterExists( final String	resourceAdapterName )
	{
		final Map<String,ResourceAdapterConfig>	resourceAdapters	=
		    getDomainRoot().getDomainConfig().getResourceAdapterConfigMap();
		
		if( ! resourceAdapters.containsKey( resourceAdapterName ) )
		{
			throw new IllegalArgumentException( "No resource adapter exists with the name: " + resourceAdapterName );
		}
	}
	
		public ObjectName
	create(
		final String	name,
		final String	resourceAdapterName,
		final String	connectionDefinitionName,
		final Map<String,String>		options )
	{
        final String[] requiredParams = new String[]
		{
			RESOURCE_ADAPTER_NAME_KEY,		resourceAdapterName,
			CONNECTION_DEFINITION_NAME_KEY,	connectionDefinitionName,
		};
		
		if ( requireValidReferences( options )  )
		{
			checkResourceAdapterExists( resourceAdapterName );
		}
		
		final Map<String,String> params	= initParams( name, requiredParams, options );
		
		final ObjectName	amxName	= createNamedChild( name, params );
		
		return( amxName );
	}
	
	
		protected void
	removeByName( final String name )
	{
		getOldResourcesMBean().removeConnectorConnectionPoolByName( name );	
    }				
}







