/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/ConnectorResourceConfigFactory.java,v 1.6 2006/03/09 20:30:37 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:37 $
 */


package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.Properties;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.ResourceRefConfig;

import com.sun.enterprise.management.config.AMXConfigImplBase;

import com.sun.enterprise.management.support.Delegate;

import com.sun.appserv.management.util.misc.MapUtil;


public final class ConnectorResourceConfigFactory  extends ResourceFactoryImplBase
{
		public
	ConnectorResourceConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
	}
  
		protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( CONFIG_NAME_KEY, "jndi-name" ) );
	}
	
		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs,
		final Properties	props )
	{
		return( getOldResourcesMBean().createConnectorResource( translatedAttrs, props, null ) );
	}
	
	
	public final static String	RESOURCE_POOL_NAME_KEY	= "PoolName";
	
	/**
         Creates a new &lt;connector-resource&gt;

         @param jndiName
         @param poolName
         @param optional
     */
		public ObjectName
	create( final String	jndiName,
            final String	poolName,
            final Map<String,String>	optional )
	{
        final String[] requiredParams = new String[]
		{
			RESOURCE_POOL_NAME_KEY,		poolName,
		};
		
		final Map<String,String> params	= initParams( jndiName, requiredParams, optional );
		
		final ObjectName	amxName	= createNamedChild( jndiName, params );
		
		return( amxName );
	}
	
		protected void
	removeByName( final String name )
	{
	    final Set<ResourceRefConfig> refs   =
	        findAllRefConfigs( XTypes.CONNECTOR_RESOURCE_CONFIG, name );
	    
	    if ( refs.size() == 0 )
	    {
		    getOldResourcesMBean().removeConnectorResourceByJndiName( name );
	    }
	    else
	    {
    	    for( final ResourceRefConfig ref : refs )
    	    {
    	        final String target = ref.getContainer().getName();
		        getOldResourcesMBean().deleteConnectorResource( name, target );
    	    }
		}	
    }		
}













