/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/OldSystemPropertiesImpl.java,v 1.2 2005/12/25 03:39:34 tcfujii Exp $
 * $Revision: 1.2 $
 * $Date: 2005/12/25 03:39:34 $
 */

package com.sun.enterprise.management.config;

import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.util.misc.ThrowableMapper;

import com.sun.enterprise.management.support.oldconfig.OldSystemProperties;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.DelegateBase;

final class OldSystemPropertiesImpl implements OldSystemProperties
{
	final Delegate	mDelegate;
	
	private final static String[]	EMPTY_SIG				= new String[ 0 ];
	private final static String[]	GET_PROPERTY_VALUE_SIG	= new String[]{ String.class.getName() };
	private final static String[]	SET_PROPERTY_SIG		= new String[]{ Attribute.class.getName() };


		public
	OldSystemPropertiesImpl( Delegate delegate )
	{
		mDelegate	= delegate;
	}
	
	/**
		We want to avoid throwing anything that is not standard on the client
		side.
	 */
		private void
	rethrowThrowable( final Throwable t )
	{
		final Throwable	result	= new ThrowableMapper( t ).map();
		
		if ( result instanceof Error )
		{
			throw (Error)result;
		}
		else if ( result instanceof RuntimeException )
		{
			throw (RuntimeException)result;
		}
		else
		{	
			throw new RuntimeException( result );
		}
	}
	
		public AttributeList
	getSystemProperties()
	{
		try
		{
			return( (AttributeList)mDelegate.invoke( "getSystemProperties", null, EMPTY_SIG ) );
		}
		catch( RuntimeException e )
		{
			rethrowThrowable( e );
		}
		return( null );
	}

		public String
	getSystemPropertyValue( final String propertyName )
	{
		try
		{
			return( (String)mDelegate.invoke( "getSystemPropertyValue",
						new Object[] { propertyName }, GET_PROPERTY_VALUE_SIG ) );
		}
		catch( RuntimeException e )
		{
			rethrowThrowable( e );
		}
		return( null );
	}

		public void
	setSystemProperty( Attribute attr )
	{
		try
		{
			mDelegate.invoke( "setSystemProperty", new Object[] { attr }, SET_PROPERTY_SIG );
		}
		catch( RuntimeException e )
		{
			rethrowThrowable( e );
		}
	}
}


