/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.ObjectName;
import javax.management.Attribute;
import javax.management.AttributeList;


import com.sun.enterprise.management.support.oldconfig.OldWebServiceEndpointConfigMBean;

public final class RegistryLocationConfigFactory  extends ConfigFactory
{
		public
	RegistryLocationConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
	}
	    
	    private OldWebServiceEndpointConfigMBean
	getOld()
	{
	    final String wsec = getFactoryContainer().getName();
	    return getOldConfigProxies().getOldWebServiceEndpointConfigMBean( wsec );
	}
	
		public ObjectName
	create( final String jndiConnectorResourceName )
	{
         final AttributeList attrs   = new AttributeList();
         attrs.add( new Attribute("connector-resource-jndi-name", jndiConnectorResourceName ) );



         final ObjectName oldObjectName  = getOld().createRegistryLocation( attrs );
         
         final ObjectName    amxObjectName = finish( oldObjectName, null );
         
         return( amxObjectName );
	}
	
		protected void
	removeByName( final String name )
	{
		getOld().removeRegistryLocationByConnectorResourceJndiName( name );	
    }		
}

