/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.Properties;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ResourceAdapterConfigKeys;
import com.sun.enterprise.management.support.Delegate;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.GSetUtil;





/**
	MBean managing all instances of &lt;resource-adapter-config&gt; .
 */

public final class ResourceAdapterConfigFactory  extends ResourceFactoryImplBase
    // implements ResourceAdapterConfigMgr
{
		public
	ResourceAdapterConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
	}

	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		ResourceAdapterConfigKeys.THREAD_POOL_IDS_KEY
	);
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
	public static final String RES_ADAPTOR_NAME_KEY      = "ResourceAdapterName";
	
		protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( ResourceAdapterConfigKeys.THREAD_POOL_IDS_KEY, "thread-pool-ids" ) );
	}

                
	/**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs,
		final Properties	properties )
	{
		final ObjectName	objectName	=
				getOldResourcesMBean().createResourceAdapterConfig( 
					translatedAttrs, properties, null );

		return( objectName );
	}

	/**
		Create a new &lt;resource-adapter-config&gt
		
		@param resourceAdapterName			
		@param optional
	 */
		public ObjectName	
	create( String resourceAdapterName, Map<String,String> optional )
    {
		final String[] requiredParams = new String[] {
			RES_ADAPTOR_NAME_KEY, resourceAdapterName,
		};

		final Map<String,String>		params	= initParams( requiredParams, optional );

		final ObjectName	amxName = createNamedChild( resourceAdapterName, params );

		return( amxName );                                                  
	}
	
	
		protected void
	removeByName( final String name )
	{
		getOldResourcesMBean().deleteResourceAdapterConfig( name, null);	
    }

}

