/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.oldconfig.OldThreadPoolsConfigMBean;


import com.sun.appserv.management.config.ThreadPoolConfigKeys;



/**
	Configuration for the &lt;thread-pools&gt; element.
 */
public final class ThreadPoolConfigFactory  extends ConfigFactory
{
		public
	ThreadPoolConfigFactory( final ConfigFactoryCallback	callbacks )
	{
		super( callbacks );
	}
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		ThreadPoolConfigKeys.MIN_THREAD_POOL_SIZE_KEY,
		ThreadPoolConfigKeys.MAX_THREAD_POOL_SIZE_KEY,
		ThreadPoolConfigKeys.IDLE_THREAD_TIMEOUT_IN_SECONDS_KEY,
		ThreadPoolConfigKeys.NUM_WORK_QUEUES_KEY
	);
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
		private OldThreadPoolsConfigMBean
	getOldThreadPoolsConfigMBean( )
	{
		return getOldConfigProxies().getOldThreadPoolsConfigMBean( getConfigName() );
	}
	
	/**
		Create a new &lt;thread-pool>
		
		@param name			name of the &lt;thread-pool> (thread-pool-id)
		@param optional
		@return ObjectName of the newly-created ThreadPoolConfig
	 */
		public ObjectName
	create( String name, Map<String,String> optional )
	{
		final Map<String,String> params	= initParams( name, null, optional );
		
		final ObjectName	amxName	= createNamedChild( name, params );
		
		return( amxName );
	}

		public void
	internalRemove( final ObjectName objectName)
	{
		final String	name	= Util.getName( objectName );
		
		getOldThreadPoolsConfigMBean().removeThreadPoolByThreadPoolId( name );
	}

		protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( CONFIG_NAME_KEY, "thread-pool-id" ) );
	}

		protected ObjectName
	createOldChildConfig( final AttributeList translatedAttrs )
	{
		final ObjectName	objectName	=
				getOldThreadPoolsConfigMBean().createThreadPool( translatedAttrs );
		
		return( objectName );
	}

}

