/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.List;
import java.util.HashMap;

import javax.management.ObjectName;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.util.misc.TypeCast;

import com.sun.appserv.management.config.TransformationRuleConfigKeys;
import com.sun.appserv.management.config.TransformationRuleConfig;


import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;

import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.AMXAttributeNameMapper;


public final class WebServiceEndpointConfigImpl  extends AMXConfigImplBase
    implements ConfigFactoryCallback
    // implements WebServiceEndpointConfig
{
    	public
    WebServiceEndpointConfigImpl( final Delegate delegate )
    {
    	super( delegate );
    }

    // this method may be superfluous as it is probably handled automatically
     public Map<String,ObjectName> getTransformationRuleConfigObjectNameMap()
     {
          return(getContaineeObjectNameMap(
            XTypes.TRANSFORMATION_RULE_CONFIG));
     }

    // this method may be superfluous as it is probably handled automatically
        public Map<String,ObjectName>
    getRegistryLocationConfigObjectNameMap()
    {
       return (getContaineeObjectNameMap(XTypes.REGISTRY_LOCATION_CONFIG));
    }

     public List<ObjectName> getTransformationRuleConfigObjectNameList() {
        final String wsepName = getName();
        final String appId = getContainer().getName();
      
        final Map<String,ObjectName>    containeeMap    =
            getContaineeObjectNameMap(TransformationRuleConfig.J2EE_TYPE);
            
        final List<ObjectName>  objectNames = TypeCast.checkList( 
            WebServiceMgrBackEnd.getManager().
                getTransformationRuleConfigObjectNameList( appId, wsepName, containeeMap ),
                    ObjectName.class);
                
        return objectNames;
     }


    @Override
        protected void
    addCustomMappings( final AMXAttributeNameMapper mapper )
    {
        super.addCustomMappings( mapper );
          
    	mapper.matchName( "MonitoringLevel", "monitoring" );
    }
}















