/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/j2ee/EJBModuleImpl.java,v 1.4 2006/03/09 20:30:44 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:44 $
 */
 
package com.sun.enterprise.management.j2ee;

import java.util.Set;
import java.util.Map;
import java.util.Collections;

import com.sun.appserv.management.j2ee.EJBModule;
import com.sun.appserv.management.j2ee.J2EETypes;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.support.Delegate;

/**
 */
public final class EJBModuleImpl extends J2EEModuleImplBase 
{
		public
	EJBModuleImpl( final Delegate delegate )
	{
		super( delegate );
	}
	
	private static final Set<String> EJB_TYPES	=
	    GSetUtil.newUnmodifiableStringSet(
		J2EETypes.ENTITY_BEAN,
		J2EETypes.STATELESS_SESSION_BEAN,
		J2EETypes.STATEFUL_SESSION_BEAN,
		J2EETypes.MESSAGE_DRIVEN_BEAN );
	
		public String[]
	getejbs()
	{
		return( GSetUtil.toStringArray( getEJBObjectNameSet() ) );
	}
	
		protected String
	getMonitoringPeerJ2EEType()
	{
		return( XTypes.EJB_MODULE_MONITOR );
	}

	
		public Set
	getEJBObjectNameSet()
	{
		return( getContaineeObjectNameSet( EJB_TYPES ) );
	}
}
