/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.j2ee;

import java.util.Map;
import java.util.Iterator;
import java.io.Serializable;

import javax.management.ObjectName;
import javax.management.AttributeNotFoundException;

import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;

import com.sun.appserv.management.util.misc.TypeCast;

import com.sun.appserv.management.j2ee.J2EELogicalServer;
import com.sun.appserv.management.j2ee.J2EETypes;

import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.oldconfig.OldApplicationsConfigMBean;

/**
	Base interface only (for cluster and standalone server)
 */
public class J2EELogicalServerImplBase
	extends J2EEManagedObjectImplBase 
{
		public
	J2EELogicalServerImplBase(
		final Delegate delegate)
	{
		super( delegate );
	}

		protected
	J2EELogicalServerImplBase( String j2eeType, Delegate delegate )
	{
		super( j2eeType, delegate );
	}

		public int
	getstate()
	{
 		throw new RuntimeException( new AttributeNotFoundException( "state" ) );
	}
 	
 		public void
 	start()
 	{
 		throw new RuntimeException( "can't start" );
 	}
 	
 		public void
 	startRecursive()
 	{
 		throw new RuntimeException( "can't startRecursive" );
 	}
 	
 		public void
 	stop()
 	{
 		throw new RuntimeException( "can't stop" );
 	}

	/**
	 * starts the app
	 */
		public void
 	startApp(String appID, Map<String,Serializable> optional)
 	{
		final OldApplicationsConfigMBean oldApplicationsMBean = 
			getOldConfigProxies().getOldApplicationsConfigMBean();

		final Map<String,Serializable> m = TypeCast.asMap(
		    oldApplicationsMBean.startAndReturnStatusAsMap( appID, getSelfName(), optional ) );
		checkDeploymentStatusForExceptions( m );
 	}
	/**
	 * stops the app
	 */
		public void
 	stopApp(String appID, Map<String,Serializable> optional)
 	{
		final OldApplicationsConfigMBean oldApplicationsMBean = 
			getOldConfigProxies().getOldApplicationsConfigMBean();

		final Map<String,Serializable>    m = TypeCast.asMap(
		    oldApplicationsMBean.stopAndReturnStatusAsMap( appID, getSelfName(), optional ) );
		
		checkDeploymentStatusForExceptions( m );
 	}
	/**
	 * Checks the DeploymentStatus and all substages.
	 *
	 * Can't depend on SUCCESS or FAILURE as the backend.DeploymentStatus sets
	 * the stageStatus to its own codes. Cannot import backend.DeploymentStatus
	 * to translate the codes.
	 */
		private void 
	checkDeploymentStatusForExceptions( Map<String,Serializable > m )
    {
		DeploymentStatus status = DeploymentSupport.mapToDeploymentStatus( m );
		
		Throwable t = status.getStageThrowable();
		
		final Iterator<DeploymentStatus> it = status.getSubStagesList().iterator();
		while ( ( t == null ) && ( it.hasNext() ) )
		{
			final DeploymentStatus m1 = it.next();
			t = status.getThrowable();
		}
		if ( null != t )
		{
			throw new RuntimeException( status.getStageStatusMessage() );
		}
    }

}

