/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.monitor;
import com.sun.appserv.management.config.LoadBalancerConfig;
import java.util.Map;

import javax.management.ObjectName;

import static com.sun.appserv.management.base.XTypes.*;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.enterprise.management.monitor.stats.LoadBalancerServerStatsImpl;
import com.sun.enterprise.management.monitor.stats.CustomMonitoringStatsImplBase;
import com.sun.appserv.management.monitor.statistics.LoadBalancerServerStats;
import com.sun.appserv.management.j2ee.statistics.StatsImpl;

public final class LoadBalancerServerMonitorImpl extends CustomMonitoringStatsImplBase {
    
    public LoadBalancerServerMonitorImpl() {
        super(LoadBalancerServerMonitor.J2EE_TYPE);
    }

    protected final Class getStatsInterface() {
        return LoadBalancerServerStats.class;
    }

    public LoadBalancerServerStats getLoadBalancerServerStats() {
        return (LoadBalancerServerStats) getStats();
    }
    
    /**
     * @return a Map of the {@link LoadBalancerServerMonitor} for this 
     * load balancer keyed by server name.
     */
    public Map<String,ObjectName> getLoadBalancerApplicationMonitorObjectNameMap() {
        return (getContaineeObjectNameMap(LOAD_BALANCER_APPLICATION_MONITOR));
    }
    
    protected StatsImpl createStatsImpl() {
        String instanceName = getName();
        String lbName = getObjectName().getKeyProperty(LOAD_BALANCER_MONITOR);
        String clusterName = getObjectName().getKeyProperty(LOAD_BALANCER_CLUSTER_MONITOR);
        Map<String, LoadBalancerConfig> loadBalancerConfigMap =
            getDomainRoot().getDomainConfig().getLoadBalancerConfigMap();
        LoadBalancerConfig loadBalancerConfig = loadBalancerConfigMap.get(lbName);
        String lbConfigName = loadBalancerConfig.getLbConfigName();        
	return new StatsImpl(getStatisticsFromImpl(new LoadBalancerServerStatsImpl(lbName,lbConfigName,clusterName,instanceName)));
    }    
}
