/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.monitor;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.JMException;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.j2ee.J2EETypes;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.CallFlowMonitor;

import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.BootUtil;



/**
*/
public final class ServerRootMonitorImpl
	extends MonitoringImplBase
	// implements ServerRootMonitor
{
	public ServerRootMonitorImpl()
	{
		super( XTypes.SERVER_ROOT_MONITOR );
	}

	
		public Map<String,ObjectName>
	getORBConnectionManagerMonitorObjectNameMap()
	{
		return( getContaineeObjectNameMap( XTypes.CONNECTION_MANAGER_MONITOR ) );
	}
	
	
	private static final Set<String> NOT_SUPERFLUOUS =
	    GSetUtil.newUnmodifiableStringSet(
    	    "getCallFlowMonitorObjectName",
    	    "getORBConnectionManagerMonitorObjectNameMap"
        );
	    protected final Set<String>
	getNotSuperfluousMethods()
	{
	    return GSetUtil.newSet( super.getNotSuperfluousMethods(), NOT_SUPERFLUOUS );
	}
	
	
		protected void
	registerMisc()
	{
		super.registerMisc();
		
		if ( getLoader().isDAS() )
		{
		    if ( ( BootUtil.getInstance().getServerName().equals( getName() ) ) )
		    {
		        // this is the ServerRootMonitor for the DAS.
		        registerCallFlow();
		    }
		}
		else
		{	
		    // they should be cascaded from other instances
		    // and ServerRootMonitorImpl does not exist there.
	         throw new RuntimeException( "ServerRootMonitorImpl expected in DAS only" );
		}

	}
	
		public final ObjectName
	getCallFlowMonitorObjectName()
	{
	    return getContaineeObjectName( XTypes.CALL_FLOW_MONITOR );
	}
	
		protected void
	unregisterMisc()
	{
	    if ( getLoader().isDAS() )
	    {
    	    try
    	    {
    		    getMBeanServer().unregisterMBean( getCallFlowMonitorObjectName() );
    		}
    		catch( JMException e )
    		{
    		    logWarning( "ServerRootMonitorImpl: exception unregistering CallFlowMonitor: " + e);
    		}
		}
	}
	
		protected final void
	registerCallFlow()
	{
		final ObjectNames	objectNames	= ObjectNames.getInstance( getJMXDomain() );
		final ObjectName	childObjectName	=
			objectNames.buildContaineeObjectName( getObjectName(),
				getFullType(), XTypes.CALL_FLOW_MONITOR,
					getName() );
		
		final CallFlowMonitorImpl	callFlow	= new CallFlowMonitorImpl();
		try
		{
            debug( "Loading CallFlowMonitor for DAS: " + childObjectName );
			getMBeanServer().registerMBean( callFlow, childObjectName );
		}
		catch( JMException e )
		{
			logWarning( "ServerRootMonitor: Can't load CallFlow" );
		}
	}
	
	final Set<String>	FAUX_CONTAINEE_TYPES	=
		GSetUtil.newUnmodifiableStringSet(
			XTypes.EJB_MODULE_MONITOR,
			XTypes.WEB_MODULE_VIRTUAL_SERVER_MONITOR
			);
		
		protected Set<String>
	getFauxChildTypes()
	{
		return( FAUX_CONTAINEE_TYPES );
	}
	
	
	
	/*
		Override default behavior to find modules that belong to ServerRootMonitor directly
		because X-ApplicationMonitor=null.
	 */
		public final Set<ObjectName>
	getContaineeObjectNameSet( final String childJ2EEType )
	{
		final Set<ObjectName>	result	= super.getContaineeObjectNameSet( childJ2EEType );
		
		if ( getFauxChildTypes().contains( childJ2EEType ) )
		{
			final String	nullAppMonitorProp	= Util.makeProp( XTypes.APPLICATION_MONITOR, AMX.NULL_NAME );

			final Set<ObjectName>	fauxContainees	= getFauxContaineeObjectNameSet( childJ2EEType, nullAppMonitorProp);
			result.addAll( fauxContainees );
		}
		
		return( result );
	}
}
