/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.offline;

import java.util.Map;
import java.util.HashMap;


import com.sun.appserv.management.base.AMXDebug;


import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;

import com.sun.enterprise.config.impl.ConfigContextImpl;


/**
    Factory for creating ConfigBeanHelpers.
    Although they can be instantiated directly, failure to use
    the factory means that certain special cases won't be dealt with.
 */
final class ConfigBeanHelperFactory
{
    private final ConfigContext mConfigContext;
    private final Map<String,ConfigBeanHelper>  mHelperCache;

    private static ConfigBeanHelperFactory INSTANCE    = null;
     
    private static Map<ConfigContext,ConfigBeanHelperFactory>   mFactories;
    
        private
    ConfigBeanHelperFactory( final ConfigContext configContext)
    {
        mConfigContext  = configContext;
        mHelperCache    = new HashMap<String,ConfigBeanHelper>();
    }

        private void
    debug( final Object o )
    {
        AMXDebug.getInstance().getOutput( "ConfigBeanHelperFactory" ).println( o );
    }
    
       protected void
	sdebug( Object o )
	{
	    debug( o );
	    System.out.println( "" + o );
	}
	
	    public static synchronized ConfigBeanHelperFactory
	getInstance( final ConfigContext configContext )
	{
        if ( mFactories == null )
        {
            mFactories  = new HashMap<ConfigContext,ConfigBeanHelperFactory>();
        }

        ConfigBeanHelperFactory   instance    = mFactories.get( configContext );
	    if ( instance == null )
	    {
	        instance    = new ConfigBeanHelperFactory( configContext );
	        mFactories.put( configContext, instance );
	    }

	    return instance;
	}
	
        private ConfigBeanHelper
    createHelper( final String xPath )
        throws ConfigException
    {
        ConfigBeanHelper    helper  = null;
        final String        type = ConfigBeanHelper._getType( xPath );
        
        final ConfigBean    configBean  = mConfigContext.exactLookup( xPath );
        if ( configBean == null )
        {
            throw new IllegalArgumentException( 
                "Null configBean returned for type: " + type );
        }
        
        if ( "auth-realm".equals( type ) )
        {
            helper  = new AuthRealmConfigBeanHelper( mConfigContext, configBean );
        }
        else if ( "security-map".equals( type ) )
        {
            helper  = new SecurityMapConfigBeanHelper( mConfigContext, configBean );
        }
        else if ( "java-config".equals( type ) )
        {
            helper  = new JavaConfigConfigBeanHelper( mConfigContext, configBean );
        }
        else
        {
            helper  = new StdConfigBeanHelper( mConfigContext, configBean );
        }
        
        debug( "CREATED: " + xPath );
        
        return helper;
    }
    
        public ConfigBeanHelper
    getHelper( final String xPath )
        throws ConfigException
    {
        if ( xPath == null )
        {
            throw new IllegalArgumentException( "null xPath" );
        }
        
        ConfigBeanHelper    helper  = mHelperCache.get( xPath );
        
        if ( helper == null )
        {
            helper  = createHelper( xPath );
            
            mHelperCache.put( xPath, helper );
        }
        
        return helper;
    }

        public ConfigBeanHelper
    getHelper( final ConfigBean configBean )
    {
        try
        {
            return getHelper( configBean.getXPath() );
        }
        catch( Exception e )
        {
            throw new RuntimeException( e );
        }
    }
}
























