/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
 
package com.sun.enterprise.management.offline;

import java.util.Set;
import java.util.List;
import java.util.Arrays;

import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;

import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;


final class JavaConfigConfigBeanHelper extends StdConfigBeanHelper
{
    static private final String JVM_OPTIONS_ATTR   = "JvmOptions";
    
        public
    JavaConfigConfigBeanHelper(
        final ConfigContext configContext,
        final ConfigBean    configBean )
    {
        super( configContext, configBean );
        
    }
    
    
       private boolean
    hasJVMOptions()
    {
        return hasValue( JVM_OPTIONS_ATTR );
    }
    
        protected Set<String>
    _getAttributeNames()
    {
        final Set<String>   attrNames = super._getAttributeNames();
        
        if ( hasJVMOptions() )
        {
            attrNames.add( JVM_OPTIONS_ATTR );
        }
        
        return attrNames;
    }
    
      
        protected Class
    getAttributeClass( final String attrName )
    {
        Class  result  = null;
        
        if ( JVM_OPTIONS_ATTR.equals( attrName ) )
        {
            result  = String[].class;
        }
        else
        {
            result  = super.getAttributeClass( attrName );
	    }
	    return result;
    }
    
    	public Object
    getAttribute( final String attrName )
    	throws AttributeNotFoundException
    {
        Object  result  = null;
        
        if ( JVM_OPTIONS_ATTR.equals( attrName ) )
        {
            result  = getJVMOptions();
        }
        else
        {
            result  = super.getAttribute( attrName );
	    }
	    return result;
    }
    
      	public void
    setAttribute( final String name, final Object value )
    	throws AttributeNotFoundException, InvalidAttributeValueException
    {
        if ( JVM_OPTIONS_ATTR.equals( name ) )
        {
            setJVMOptions( (String[])value );
        }
        else
        {
    	    super.setAttribute( name, value );
    	}
    }
    
    
        private com.sun.enterprise.config.serverbeans.JavaConfig
    getJavaConfigConfigBean()
    {
        return (com.sun.enterprise.config.serverbeans.JavaConfig)
            getConfigBean();
    }
    
        public String[]
    getJVMOptions()
    {
        // presumably spaces are not allowed in a JVM option
        final String[]  result  = getJavaConfigConfigBean().getJvmOptions();
        
        return result;
    }
    
        public void
    setJVMOptions( final String[] optionsIn )
    {
        // ensure no duplicates
        final Set<String>   optionsSet    = GSetUtil.newUnmodifiableStringSet( optionsIn );
        final String[]  options = GSetUtil.toStringArray( optionsSet );
        Arrays.sort( options );
        
        getJavaConfigConfigBean().setJvmOptions( options );
    }
    
}

















